/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5 {
    private final long msb;
    private final long lsb;

    public MD5(long msb, long lsb) {
        this.msb = msb;
        this.lsb = lsb;
    }

    public MD5(String str) {
        if (str.length() != 32) {
            throw new IllegalArgumentException("invalid string length " + str.length());
        }
        this.msb = (Long.parseLong(str.substring(0, 8), 16) << 32) + Long.parseLong(str.substring(8, 16), 16);
        this.lsb = (Long.parseLong(str.substring(16, 24), 16) << 32) + Long.parseLong(str.substring(24, 32), 16);
    }

    public MD5(byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("invalid bytes length " + bytes.length);
        }
        this.msb = MD5.getLong(bytes, 0);
        this.lsb = MD5.getLong(bytes, 8);
    }

    public long[] getLongs() {
        return new long[]{this.msb, this.lsb};
    }

    public long getMsb() {
        return this.msb;
    }

    public long getLsb() {
        return this.lsb;
    }

    public byte[] getBytes() {
        byte[] buf = new byte[16];
        MD5.setLong(buf, 0, this.msb);
        MD5.setLong(buf, 8, this.lsb);
        return buf;
    }

    public static MD5 digest(InputStream in) throws IOException {
        int read;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) > 0) {
            md.update(buffer, 0, read);
        }
        return new MD5(md.digest());
    }

    public static MD5 digest(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            MD5 mD5 = MD5.digest(input);
            return mD5;
        }
    }

    public String toString() {
        return String.format("%016x%016x", this.msb, this.lsb);
    }

    public int hashCode() {
        return (int)(this.msb >> 32 ^ this.msb ^ this.lsb >> 32 ^ this.lsb);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MD5 md5 = (MD5)o;
        return this.lsb == md5.lsb && this.msb == md5.msb;
    }

    private static long getLong(byte[] b, int offs) {
        return ((long)(b[offs] & 0xFF) << 56) + ((long)(b[1 + offs] & 0xFF) << 48) + ((long)(b[2 + offs] & 0xFF) << 40) + ((long)(b[3 + offs] & 0xFF) << 32) + ((long)(b[4 + offs] & 0xFF) << 24) + ((long)(b[5 + offs] & 0xFF) << 16) + ((long)(b[6 + offs] & 0xFF) << 8) + (long)(b[7 + offs] & 0xFF);
    }

    private static void setLong(byte[] b, int offs, long v) {
        b[offs] = (byte)(v >>> 56 & 0xFFL);
        b[offs + 1] = (byte)(v >>> 48 & 0xFFL);
        b[offs + 2] = (byte)(v >>> 40 & 0xFFL);
        b[offs + 3] = (byte)(v >>> 32 & 0xFFL);
        b[offs + 4] = (byte)(v >>> 24 & 0xFFL);
        b[offs + 5] = (byte)(v >>> 16 & 0xFFL);
        b[offs + 6] = (byte)(v >>> 8 & 0xFFL);
        b[offs + 7] = (byte)(v >>> 0 & 0xFFL);
    }
}

