/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.simple;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.apache.sling.distribution.queue.DistributionQueueItem;

public class QueueItemMapper {
    DistributionQueueItem readQueueItem(String line) {
        String[] split = line.split(" ", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid item found " + line);
        }
        String packageId = split[0];
        String infoString = split[1];
        HashMap<String, Object> info = new HashMap<String, Object>();
        JsonReader reader = Json.createReader((Reader)new StringReader(infoString));
        JsonObject jsonObject = reader.readObject();
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((JsonValue)entry.getValue()).getValueType().equals((Object)JsonValue.ValueType.ARRAY)) {
                JsonArray value = jsonObject.getJsonArray((String)entry.getKey());
                String[] a = new String[value.size()];
                for (int i = 0; i < a.length; ++i) {
                    a[i] = value.getString(i);
                }
                info.put((String)entry.getKey(), a);
                continue;
            }
            if (JsonValue.NULL.equals(entry.getValue())) {
                info.put((String)entry.getKey(), null);
                continue;
            }
            if (((JsonValue)entry.getValue()).getValueType().equals((Object)JsonValue.ValueType.NUMBER)) {
                try {
                    Number n = numberFormat.parse(((JsonValue)entry.getValue()).toString());
                    info.put((String)entry.getKey(), n);
                    continue;
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Failed to read queue item", e);
                }
            }
            info.put((String)entry.getKey(), ((JsonString)entry.getValue()).getString());
        }
        return new DistributionQueueItem(packageId, info);
    }

    String writeQueueItem(DistributionQueueItem item) {
        String packageId = item.getPackageId();
        StringWriter w = new StringWriter();
        JsonGenerator jsonWriter = Json.createGenerator((Writer)w);
        jsonWriter.writeStartObject();
        for (Map.Entry entry : item.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String[]) {
                jsonWriter.writeStartArray((String)entry.getKey());
                for (String s : (String[])value) {
                    jsonWriter.write(s);
                }
                jsonWriter.writeEnd();
                continue;
            }
            if (value == null) {
                jsonWriter.write(key, JsonValue.NULL);
                continue;
            }
            if (value instanceof String) {
                jsonWriter.write(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                jsonWriter.write(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                jsonWriter.write(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Float) {
                jsonWriter.write(key, (double)((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                jsonWriter.write(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Long) {
                jsonWriter.write(key, ((Long)value).longValue());
                continue;
            }
            jsonWriter.write(key, String.valueOf(value));
        }
        jsonWriter.writeEnd();
        jsonWriter.close();
        return packageId + " " + w.toString();
    }
}

