/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.fields;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.reference.forms.FieldHandler;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FieldHandler.class})
@Designate(ocd=Config.class)
public class SelectionHandler
implements FieldHandler {
    public static final String DEFAULT_RESOURCE_TYPE = "reference/components/forms/fields/selection";
    private static final Logger log = LoggerFactory.getLogger(SelectionHandler.class);
    private final Config config;

    @Activate
    public SelectionHandler(Config config) {
        this.config = config;
    }

    @Override
    public boolean handles(Resource fieldResource) {
        return FormUtils.handles(this.config.supportedTypes(), fieldResource);
    }

    @Override
    public void handleField(SlingHttpServletRequest request, Resource fieldResource, Map<String, Object> formData) throws FormException {
        log.trace("handleField");
        String name = FieldHandler.getName(fieldResource);
        if (this.isMultiple(fieldResource)) {
            String[] value = this.stripBlank(request.getParameterValues(name));
            if (value.length == 0) {
                if (FieldHandler.isRequired(fieldResource)) {
                    throw new FormException("Field " + name + " not set and is required");
                }
                log.debug("Ignoring unset value: {}", (Object)name);
            } else {
                log.debug("Setting value for: {}", (Object)name);
                formData.put(name, value);
            }
        } else {
            String value = request.getParameter(name);
            if (StringUtils.isBlank((CharSequence)value)) {
                if (FieldHandler.isRequired(fieldResource)) {
                    throw new FormException("Field " + name + " not set and is required");
                }
                log.debug("Ignoring unset value: {}", (Object)name);
            } else {
                log.debug("Setting value for: {}", (Object)name);
                formData.put(name, value);
            }
        }
    }

    private String[] stripBlank(String[] parameterValues) {
        return Optional.ofNullable(parameterValues).map(v -> {
            List<String> values = Arrays.stream(v).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            return values.toArray(new String[values.size()]);
        }).orElse(new String[0]);
    }

    private boolean isMultiple(Resource fieldResource) {
        return (Boolean)fieldResource.getValueMap().get("multiple", (Object)false);
    }

    @ObjectClassDefinition(name="%cms.reference.selection.name", description="%cms.reference.selection.description", localization="OSGI-INF/l10n/bundle")
    public static @interface Config {
        @AttributeDefinition(name="%cms.reference.supportedTypes.name", description="%cms.reference.supportedTypes.description", defaultValue={"reference/components/forms/fields/selection"})
        public String[] supportedTypes() default {"reference/components/forms/fields/selection"};
    }
}

