/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.customize.interceptor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.agent.core.util.CustomizeExpression;
import org.apache.skywalking.apm.plugin.customize.conf.CustomizeConfiguration;
import org.apache.skywalking.apm.plugin.customize.conf.MethodConfiguration;

class BaseInterceptorMethods {
    BaseInterceptorMethods() {
    }

    void beforeMethod(Method method, Object[] allArguments, MethodInvocationContext miContext) {
        Map spanLogs;
        Map<String, Object> configuration = CustomizeConfiguration.INSTANCE.getConfiguration(method);
        String operationName = MethodConfiguration.getOperationName(configuration);
        Map evalContext = CustomizeExpression.evaluationContext((Object[])allArguments);
        Map<String, String> tags = MethodConfiguration.getTags(configuration);
        Map<String, String> logs = MethodConfiguration.getLogs(configuration);
        Map spanTags = tags == null ? Collections.EMPTY_MAP : new HashMap(tags.size());
        Map map = spanLogs = logs == null ? Collections.EMPTY_MAP : new HashMap(logs.size());
        if (evalContext == null || evalContext.isEmpty()) {
            SpanDataHolder spanDataHolder = new SpanDataHolder(ContextManager.createLocalSpan((String)operationName), tags, logs, spanTags, spanLogs);
            miContext.setContext((Object)spanDataHolder);
        } else {
            List<String> operationNameSuffixes = MethodConfiguration.getOperationNameSuffixes(configuration);
            StringBuilder operationNameSuffix = new StringBuilder();
            if (operationNameSuffixes != null && !operationNameSuffixes.isEmpty()) {
                for (String expression : operationNameSuffixes) {
                    operationNameSuffix.append("/");
                    operationNameSuffix.append(CustomizeExpression.parseExpression((String)expression, (Map)evalContext));
                }
            }
            this.evalAndPopulate(evalContext, false, tags, spanTags);
            this.evalAndPopulate(evalContext, false, logs, spanLogs);
            operationName = operationNameSuffix.insert(0, operationName).toString();
            AbstractSpan localSpan = ContextManager.createLocalSpan((String)operationName);
            this.tagSpanTags(localSpan, spanTags);
            this.tagSpanLogs(localSpan, spanLogs);
            spanTags.clear();
            spanLogs.clear();
            SpanDataHolder spanDataHolder = new SpanDataHolder(localSpan, tags, logs, spanTags, spanLogs);
            miContext.setContext((Object)spanDataHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterMethod(Method method, Object ret, MethodInvocationContext miContext) {
        if (!ContextManager.isActive()) {
            return;
        }
        SpanDataHolder spanDataHolder = (SpanDataHolder)miContext.getContext();
        if (spanDataHolder == null || spanDataHolder.localSpan == null) {
            return;
        }
        AbstractSpan localSpan = spanDataHolder.localSpan;
        if (ret == null) {
            ContextManager.stopSpan((AbstractSpan)localSpan);
            return;
        }
        Map<String, String> tags = spanDataHolder.tags;
        Map<String, String> logs = spanDataHolder.logs;
        Map<String, String> spanTags = spanDataHolder.spanTags;
        Map<String, String> spanLogs = spanDataHolder.spanLogs;
        try {
            Map evalContext = CustomizeExpression.evaluationReturnContext((Object)ret);
            this.evalAndPopulate(evalContext, true, tags, spanTags);
            this.evalAndPopulate(evalContext, true, logs, spanLogs);
            this.tagSpanTags(localSpan, spanTags);
            this.tagSpanLogs(localSpan, spanLogs);
            spanTags.clear();
            spanLogs.clear();
        }
        finally {
            ContextManager.stopSpan((AbstractSpan)localSpan);
        }
    }

    void handleMethodException(Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private void evalAndPopulate(Map<String, Object> context, boolean returnExpr, Map<String, String> exprMap, Map<String, String> toMap) {
        if (exprMap != null && !exprMap.isEmpty()) {
            for (Map.Entry<String, String> entry : exprMap.entrySet()) {
                String expression = entry.getValue();
                if (this.isReturnedObjExpression(expression) != returnExpr) continue;
                toMap.put(entry.getKey(), CustomizeExpression.parseExpression((String)expression, context));
            }
        }
    }

    private void tagSpanTags(AbstractSpan span, Map<String, String> spanTags) {
        if (spanTags != null && !spanTags.isEmpty()) {
            for (Map.Entry<String, String> tag : spanTags.entrySet()) {
                span.tag(Tags.ofKey((String)tag.getKey()), tag.getValue());
            }
        }
    }

    private void tagSpanLogs(AbstractSpan span, Map<String, String> spanLogs) {
        if (spanLogs != null && !spanLogs.isEmpty()) {
            span.log(System.currentTimeMillis(), spanLogs);
        }
    }

    private boolean isReturnedObjExpression(String expression) {
        String[] es = expression.split("\\.");
        return "returnedObj".equals(es[0]);
    }

    private static class SpanDataHolder {
        final AbstractSpan localSpan;
        final Map<String, String> tags;
        final Map<String, String> logs;
        final Map<String, String> spanTags;
        final Map<String, String> spanLogs;

        public SpanDataHolder(AbstractSpan localSpan, Map<String, String> tags, Map<String, String> logs, Map<String, String> spanTags, Map<String, String> spanLogs) {
            this.localSpan = localSpan;
            this.tags = tags;
            this.logs = logs;
            this.spanTags = spanTags;
            this.spanLogs = spanLogs;
        }
    }
}

