/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.activation.micrometer;

import io.micrometer.observation.Observation;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.toolkit.activation.micrometer.TaggingHelper;
import org.apache.skywalking.apm.util.StringUtil;

public class MicrometerDefaultTracingHandlerInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String methodName = method.getName();
        if ("onStart".equals(methodName)) {
            Observation.Context context = (Observation.Context)allArguments[0];
            AbstractSpan span = ContextManager.createLocalSpan((String)context.getName());
            span.setComponent((Component)ComponentsDefine.MICROMETER);
        } else if ("onStop".equals(methodName)) {
            Observation.Context context = (Observation.Context)allArguments[0];
            SpanLayer spanLayer = TaggingHelper.toLayer(context.getAllKeyValues());
            AbstractSpan abstractSpan = ContextManager.activeSpan();
            abstractSpan.setOperationName(StringUtil.isBlank((String)context.getContextualName()) ? context.getName() : context.getContextualName());
            context.getAllKeyValues().forEach(keyValue -> abstractSpan.tag(Tags.ofKey((String)keyValue.getKey()), keyValue.getValue()));
            if (spanLayer != null) {
                abstractSpan.setLayer(spanLayer);
            }
            ContextManager.stopSpan();
        } else if ("onError".equals(methodName)) {
            Observation.Context context = (Observation.Context)allArguments[0];
            ContextManager.activeSpan().log(context.getError());
        } else if ("onEvent".equals(methodName)) {
            Observation.Event event = (Observation.Event)allArguments[0];
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("event", event.getContextualName() != null ? event.getContextualName() : event.getName());
            ContextManager.activeSpan().log(System.currentTimeMillis(), map);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

