/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.kubernetes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.time.Duration;
import java.util.Optional;
import org.apache.skywalking.library.kubernetes.ObjectID;

public enum KubernetesPods {
    INSTANCE;

    private final LoadingCache<String, Optional<Pod>> podByIP;
    private final LoadingCache<ObjectID, Optional<Pod>> podByObjectID;

    private KubernetesPods() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(5L));
        this.podByIP = cacheBuilder.build((CacheLoader)new CacheLoader<String, Optional<Pod>>(){

            public Optional<Pod> load(String ip) {
                try (KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();){
                    Optional<Pod> optional = ((PodList)((FilterWatchListDeletable)((AnyNamespaceOperation)kubernetesClient.pods().inAnyNamespace()).withField("status.podIP", ip)).list()).getItems().stream().findFirst();
                    return optional;
                }
            }
        });
        this.podByObjectID = cacheBuilder.build((CacheLoader)new CacheLoader<ObjectID, Optional<Pod>>(){

            public Optional<Pod> load(ObjectID objectID) {
                try (KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();){
                    Optional<Pod> optional = Optional.ofNullable((Pod)((PodResource)((NonNamespaceOperation)kubernetesClient.pods().inNamespace(objectID.namespace())).withName(objectID.name())).get());
                    return optional;
                }
            }
        });
    }

    public Optional<Pod> findByIP(String ip) {
        return (Optional)this.podByIP.get((Object)ip);
    }

    public Optional<Pod> findByObjectID(ObjectID id) {
        return (Optional)this.podByObjectID.get((Object)id);
    }
}

