/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.Timestamp;
import java.util.LinkedList;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.stream.v1.BanyandbStream;
import org.apache.skywalking.banyandb.v1.client.AbstractWrite;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;
import org.apache.skywalking.banyandb.v1.client.metadata.Serializable;

public class StreamWrite
extends AbstractWrite<BanyandbStream.WriteRequest> {
    private final String elementId;

    StreamWrite(MetadataCache.EntityMetadata entityMetadata, String elementId, long timestamp) {
        super(entityMetadata, timestamp);
        this.elementId = elementId;
    }

    StreamWrite(MetadataCache.EntityMetadata entityMetadata, String elementId) {
        super(entityMetadata);
        this.elementId = elementId;
    }

    public StreamWrite tag(String tagName, Serializable<BanyandbModel.TagValue> tagValue) throws BanyanDBException {
        return (StreamWrite)super.tag(tagName, tagValue);
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    protected BanyandbStream.WriteRequest build(BanyandbCommon.Metadata metadata, Timestamp ts) {
        BanyandbStream.WriteRequest.Builder builder = BanyandbStream.WriteRequest.newBuilder();
        builder.setMetadata(metadata);
        BanyandbStream.ElementValue.Builder elemValBuilder = BanyandbStream.ElementValue.newBuilder();
        elemValBuilder.setElementId(this.elementId);
        elemValBuilder.setTimestamp(ts);
        int lastFamilyOffset = 0;
        for (int tagsPerFamily : this.entityMetadata.getTagFamilyCapacity()) {
            boolean firstNonNullTagFound = false;
            LinkedList<BanyandbModel.TagValue> tags = new LinkedList<BanyandbModel.TagValue>();
            for (int j = tagsPerFamily - 1; j >= 0; --j) {
                Object obj = this.tags[lastFamilyOffset + j];
                if (obj == null) {
                    if (!firstNonNullTagFound) continue;
                    tags.addFirst(TagAndValue.nullTagValue().serialize());
                    continue;
                }
                firstNonNullTagFound = true;
                tags.addFirst((BanyandbModel.TagValue)((Serializable)obj).serialize());
            }
            lastFamilyOffset += tagsPerFamily;
            elemValBuilder.addTagFamilies(BanyandbModel.TagFamilyForWrite.newBuilder().addAllTags(tags).build());
        }
        builder.setElement(elemValBuilder);
        builder.setMessageId(System.nanoTime());
        return builder.build();
    }

    public String getElementId() {
        return this.elementId;
    }
}

