/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.management.ui.menu;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.management.ui.menu.UIMenu;
import org.apache.skywalking.oap.server.core.management.ui.menu.UIMenuItemSetting;
import org.apache.skywalking.oap.server.core.query.MetadataQueryService;
import org.apache.skywalking.oap.server.core.query.type.MenuItem;
import org.apache.skywalking.oap.server.core.storage.management.UIMenuManagementDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIMenuManagementService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UIMenuManagementService.class);
    private static final String MENU_ID = "1";
    private static final Gson GSON = new Gson();
    private final LoadingCache<Boolean, List<MenuItem>> menuItemCache;
    private UIMenuManagementDAO menuDAO;
    private ModuleManager moduleManager;
    private MetadataQueryService metadataQueryService;

    public UIMenuManagementService(ModuleManager moduleManager, CoreModuleConfig moduleConfig) {
        this.moduleManager = moduleManager;
        this.menuItemCache = CacheBuilder.newBuilder().maximumSize(1L).refreshAfterWrite((long)moduleConfig.getUiMenuRefreshInterval(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Boolean, List<MenuItem>>(){

            public List<MenuItem> load(Boolean key) throws Exception {
                return UIMenuManagementService.this.fetchMenuItems();
            }
        });
    }

    private UIMenuManagementDAO getMenuDAO() {
        if (this.menuDAO == null) {
            this.menuDAO = (UIMenuManagementDAO)this.moduleManager.find("storage").provider().getService(UIMenuManagementDAO.class);
        }
        return this.menuDAO;
    }

    private MetadataQueryService getMetadataQueryService() {
        if (this.metadataQueryService == null) {
            this.metadataQueryService = (MetadataQueryService)this.moduleManager.find("core").provider().getService(MetadataQueryService.class);
        }
        return this.metadataQueryService;
    }

    public void saveMenu(List<UIMenuItemSetting> menuItems) throws IOException {
        if (this.getMenuDAO().getMenu(MENU_ID) != null) {
            this.getMenuItems();
            return;
        }
        UIMenu menu = new UIMenu();
        menu.setMenuId(MENU_ID);
        menu.setUpdateTime(System.currentTimeMillis());
        menu.setConfigurationJson(GSON.toJson(menuItems));
        this.getMenuDAO().saveMenu(menu);
        this.getMenuItems();
    }

    public List<MenuItem> getMenuItems() {
        return (List)this.menuItemCache.get((Object)true);
    }

    private List<MenuItem> fetchMenuItems() throws IOException {
        UIMenu menu = this.getMenuDAO().getMenu(MENU_ID);
        if (menu == null) {
            throw new IllegalStateException("cannot found UI menu");
        }
        List menuItems = (List)GSON.fromJson(menu.getConfigurationJson(), new TypeToken<List<UIMenuItemSetting>>(){}.getType());
        return this.convertToMenuItems(menuItems);
    }

    private List<MenuItem> convertToMenuItems(List<UIMenuItemSetting> settings) throws IOException {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (UIMenuItemSetting setting : settings) {
            MenuItem item = new MenuItem();
            boolean shouldActivate = true;
            if (CollectionUtils.isNotEmpty(setting.getMenus())) {
                List<MenuItem> subItems = this.convertToMenuItems(setting.getMenus());
                shouldActivate = subItems.stream().anyMatch(MenuItem::isActivate);
                item.setSubItems(subItems);
            } else if (StringUtil.isNotEmpty((String)setting.getLayer())) {
                shouldActivate = CollectionUtils.isNotEmpty(this.getMetadataQueryService().listServices(setting.getLayer(), null));
            }
            item.setTitle(setting.getTitle());
            item.setIcon(setting.getIcon());
            item.setLayer(StringUtil.isEmpty((String)setting.getLayer()) ? "" : setting.getLayer());
            item.setDescription(setting.getDescription());
            item.setDocumentLink(setting.getDocumentLink());
            item.setI18nKey(setting.getI18nKey());
            item.setActivate(shouldActivate);
            if (CollectionUtils.isEmpty(item.getSubItems())) {
                item.setSubItems(Collections.emptyList());
            }
            items.add(item);
        }
        return items;
    }
}

