/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataLabel;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Arg;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ConstOne;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.DefaultValue;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;

@MetricsFunction(functionName="labelCount")
public abstract class LabelCountMetrics
extends Metrics
implements LabeledValueHolder {
    protected static final String DATASET = "dataset";
    protected static final String VALUE = "datatable_value";
    protected static final String LABEL_NAME = "n";
    @Column(name="dataset", storageOnly=true)
    @BanyanDB.MeasureField
    private DataTable dataset = new DataTable(30);
    @Column(name="datatable_value", dataType=Column.ValueDataType.LABELED_VALUE, storageOnly=true)
    @ElasticSearch.Column(legacyName="value")
    @BanyanDB.MeasureField
    private DataTable value = new DataTable(30);
    private boolean isCalculated;
    private int maxLabelCount;

    @Entrance
    public final void combine(@Arg String label, @ConstOne long count, @DefaultValue(value="50") int maxLabelCount) {
        this.isCalculated = false;
        this.maxLabelCount = maxLabelCount;
        this.dataset.valueAccumulation(label, count, maxLabelCount);
    }

    @Override
    public boolean combine(Metrics metrics) {
        this.isCalculated = false;
        LabelCountMetrics labelCountMetrics = (LabelCountMetrics)metrics;
        this.dataset.append(labelCountMetrics.dataset, labelCountMetrics.maxLabelCount);
        return true;
    }

    @Override
    public void calculate() {
        if (this.isCalculated) {
            return;
        }
        for (String key : this.dataset.keys()) {
            DataLabel label = new DataLabel();
            label.put(LABEL_NAME, key);
            this.value.put(label, this.dataset.get(key));
        }
    }

    @Override
    public DataTable getValue() {
        return this.value;
    }

    @Generated
    public DataTable getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(DataTable dataset) {
        this.dataset = dataset;
    }

    @Generated
    public void setValue(DataTable value) {
        this.value = value;
    }
}

