/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorHelper;
import graphql.PublicApi;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@PublicApi
public class ExceptionWhileDataFetching
implements GraphQLError {
    private final String message;
    private final List<Object> path;
    private final Throwable exception;
    private final List<SourceLocation> locations;
    private final Map<String, Object> extensions;

    public ExceptionWhileDataFetching(ResultPath path, Throwable exception, SourceLocation sourceLocation) {
        this.path = Assert.assertNotNull(path).toList();
        this.exception = Assert.assertNotNull(exception);
        this.locations = Collections.singletonList(sourceLocation);
        this.extensions = this.mkExtensions(exception);
        this.message = this.mkMessage(path, exception);
    }

    private String mkMessage(ResultPath path, Throwable exception) {
        return String.format("Exception while fetching data (%s) : %s", path, exception.getMessage());
    }

    private Map<String, Object> mkExtensions(Throwable exception) {
        Map<String, Object> map;
        LinkedHashMap<String, Object> extensions = null;
        if (exception instanceof GraphQLError && (map = ((GraphQLError)((Object)exception)).getExtensions()) != null) {
            extensions = new LinkedHashMap<String, Object>(map);
        }
        return extensions;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    @Override
    public List<Object> getPath() {
        return this.path;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public ErrorType getErrorType() {
        return ErrorType.DataFetchingException;
    }

    public String toString() {
        return "ExceptionWhileDataFetching{path=" + this.path + ", exception=" + this.exception + ", locations=" + this.locations + "}";
    }

    public boolean equals(Object o) {
        return GraphqlErrorHelper.equals(this, o);
    }

    public int hashCode() {
        return GraphqlErrorHelper.hashCode(this);
    }
}

