/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.io.IOException;
import lombok.Generated;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.oap.server.core.management.ui.menu.UIMenu;
import org.apache.skywalking.oap.server.core.storage.management.UIMenuManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBUIMenuManagementDAO
extends AbstractBanyanDBDAO
implements UIMenuManagementDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBUIMenuManagementDAO.class);

    public BanyanDBUIMenuManagementDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public UIMenu getMenu(String id) throws IOException {
        BanyandbProperty.Property p = ((BanyanDBStorageClient)this.getClient()).queryProperty("property", "ui_menu", id);
        if (p == null) {
            return null;
        }
        return this.parse(p);
    }

    public void saveMenu(UIMenu menu) throws IOException {
        BanyandbProperty.Property property = BanyandbProperty.Property.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup("property").setName("ui_menu")).setId(menu.getMenuId()).addTags(TagAndValue.newStringTag((String)"configuration", (String)menu.getConfigurationJson()).build()).addTags(TagAndValue.newLongTag((String)"update_time", (long)menu.getUpdateTime()).build()).build();
        ((BanyanDBStorageClient)this.getClient()).apply(property);
    }

    public UIMenu parse(BanyandbProperty.Property property) {
        UIMenu menu = new UIMenu();
        menu.setMenuId(property.getId());
        for (BanyandbModel.Tag tag : property.getTagsList()) {
            TagAndValue tagAndValue = TagAndValue.fromProtobuf((BanyandbModel.Tag)tag);
            if (tagAndValue.getTagName().equals("configuration")) {
                menu.setConfigurationJson((String)tagAndValue.getValue());
                continue;
            }
            if (!tagAndValue.getTagName().equals("update_time")) continue;
            menu.setUpdateTime(Long.valueOf(((Number)tagAndValue.getValue()).longValue()));
        }
        return menu;
    }
}

