/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil;

public class HashCommon {
    public static int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    public static int float2int(float f) {
        return Float.floatToRawIntBits(f);
    }

    public static int double2int(double d) {
        long l = Double.doubleToRawLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public static int long2int(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static int nextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static long nextPowerOfTwo(long x) {
        return 1L << 64 - Long.numberOfLeadingZeros(x - 1L);
    }

    public static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((double)n * (double)f), n - 1);
    }

    public static int arraySize(int expected, float f) {
        long s = Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((double)expected / (double)f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }
}

