/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.util.ThreadFactories;
import com.linecorp.armeria.common.util.TransportType;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.channel.AbstractEventLoop;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.Future;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class EventLoopGroups {
    private static final EventLoop directEventLoop = new DirectEventLoop();
    private static final Runnable NO_OP = () -> {};

    public static EventLoopGroup newEventLoopGroup(int numThreads) {
        return EventLoopGroups.newEventLoopGroup(numThreads, false);
    }

    public static EventLoopGroup newEventLoopGroup(int numThreads, boolean useDaemonThreads) {
        return EventLoopGroups.newEventLoopGroup(numThreads, "armeria-eventloop", useDaemonThreads);
    }

    public static EventLoopGroup newEventLoopGroup(int numThreads, String threadNamePrefix) {
        return EventLoopGroups.newEventLoopGroup(numThreads, threadNamePrefix, false);
    }

    public static EventLoopGroup newEventLoopGroup(int numThreads, String threadNamePrefix, boolean useDaemonThreads) {
        Preconditions.checkArgument(numThreads > 0, "numThreads: %s (expected: > 0)", numThreads);
        Objects.requireNonNull(threadNamePrefix, "threadNamePrefix");
        TransportType type = Flags.transportType();
        String prefix = threadNamePrefix + '-' + type.lowerCasedName();
        return EventLoopGroups.newEventLoopGroup(numThreads, ThreadFactories.newEventLoopThreadFactory(prefix, useDaemonThreads));
    }

    public static EventLoopGroup newEventLoopGroup(int numThreads, ThreadFactory threadFactory) {
        Preconditions.checkArgument(numThreads > 0, "numThreads: %s (expected: > 0)", numThreads);
        Objects.requireNonNull(threadFactory, "threadFactory");
        TransportType type = Flags.transportType();
        return type.newEventLoopGroup(numThreads, unused -> threadFactory);
    }

    public static EventLoopGroup warmUp(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        eventLoopGroup.forEach(executor -> executor.submit(NO_OP));
        return eventLoopGroup;
    }

    public static EventLoop directEventLoop() {
        return directEventLoop;
    }

    @Deprecated
    public static Class<? extends ServerChannel> serverChannelType(EventLoopGroup eventLoopGroup) {
        return TransportType.serverChannelType(Objects.requireNonNull(eventLoopGroup, "eventLoopGroup"));
    }

    @Deprecated
    public static Class<? extends SocketChannel> socketChannelType(EventLoopGroup eventLoopGroup) {
        return TransportType.socketChannelType(Objects.requireNonNull(eventLoopGroup, "eventLoopGroup"));
    }

    @Deprecated
    public static Class<? extends DatagramChannel> datagramChannelType(EventLoopGroup eventLoopGroup) {
        return TransportType.datagramChannelType(Objects.requireNonNull(eventLoopGroup, "eventLoopGroup"));
    }

    private EventLoopGroups() {
    }

    private static final class DirectEventLoop
    extends AbstractEventLoop {
        private DirectEventLoop() {
        }

        @Override
        public ChannelFuture register(Channel channel) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture register(ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture register(Channel channel, ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean inEventLoop(Thread thread) {
            return true;
        }

        @Override
        public boolean isShuttingDown() {
            return false;
        }

        @Override
        public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<?> terminationFuture() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        public String toString() {
            return EventLoopGroups.class.getSimpleName() + ".directEventLoop()";
        }
    }
}

