/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.List;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gmi.MI_Georectified;
import org.opengis.geometry.primitive.Point;
import org.opengis.metadata.spatial.GCP;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Georectified_Type", propOrder={"checkPointAvailable", "checkPointDescription", "cornerPoints", "centerPoint", "pointInPixel", "transformationDimensionDescription", "transformationDimensionMapping", "checkPoints"})
@XmlRootElement(name="MD_Georectified")
@XmlSeeAlso(value={MI_Georectified.class})
public class DefaultGeorectified
extends DefaultGridSpatialRepresentation
implements Georectified {
    private static final long serialVersionUID = -2924562334097446037L;
    private static final byte CHECK_POINT_MASK = 2;
    private InternationalString checkPointDescription;
    private List<Point> cornerPoints;
    private Point centerPoint;
    private PixelOrientation pointInPixel;
    private InternationalString transformationDimensionDescription;
    private Collection<InternationalString> transformationDimensionMapping;
    private Collection<GCP> checkPoints;

    public DefaultGeorectified() {
    }

    public DefaultGeorectified(Georectified object) {
        super((GridSpatialRepresentation)object);
        if (object != null) {
            this.checkPointDescription = object.getCheckPointDescription();
            this.cornerPoints = DefaultGeorectified.copyList(object.getCornerPoints(), Point.class);
            this.centerPoint = object.getCenterPoint();
            this.pointInPixel = object.getPointInPixel();
            this.transformationDimensionDescription = object.getTransformationDimensionDescription();
            this.transformationDimensionMapping = DefaultGeorectified.copyCollection(object.getTransformationDimensionMapping(), InternationalString.class);
            this.checkPoints = DefaultGeorectified.copyCollection(object.getCheckPoints(), GCP.class);
            if (this.checkPointDescription != null || object.isCheckPointAvailable()) {
                this.booleans = (byte)(this.booleans | 2);
            }
        }
    }

    public static DefaultGeorectified castOrCopy(Georectified object) {
        if (object == null || object instanceof DefaultGeorectified) {
            return (DefaultGeorectified)object;
        }
        return new DefaultGeorectified(object);
    }

    @XmlElement(name="checkPointAvailability", required=true)
    public boolean isCheckPointAvailable() {
        return (this.booleans & 2) != 0;
    }

    public void setCheckPointAvailable(boolean newValue) {
        this.checkWritePermission(this.isDefined((byte)2));
        if (newValue) {
            this.booleans = (byte)(this.booleans | 2);
        } else {
            if (this.checkPointDescription != null && (this.booleans & 2) != 0) {
                Context.warningOccured(Context.current(), DefaultGeorectified.class, "setCheckPointAvailable", Messages.class, (short)28, "checkPointDescription", "checkPointAvailability");
            }
            this.booleans = (byte)(this.booleans & 0xFFFFFFFD);
        }
    }

    @XmlElement(name="checkPointDescription")
    public InternationalString getCheckPointDescription() {
        return (this.booleans & 2) != 0 ? this.checkPointDescription : null;
    }

    public void setCheckPointDescription(InternationalString newValue) {
        this.checkWritePermission(this.checkPointDescription);
        this.checkPointDescription = newValue;
        if (newValue != null) {
            this.booleans = (byte)(this.booleans | 2);
        }
    }

    @XmlElement(name="cornerPoints", required=true)
    public List<Point> getCornerPoints() {
        this.cornerPoints = this.nonNullList(this.cornerPoints, Point.class);
        return this.cornerPoints;
    }

    public void setCornerPoints(List<? extends Point> newValues) {
        this.cornerPoints = this.writeList(newValues, this.cornerPoints, Point.class);
    }

    @XmlElement(name="centrePoint")
    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(Point newValue) {
        this.checkWritePermission(this.centerPoint);
        this.centerPoint = newValue;
    }

    @XmlElement(name="pointInPixel", required=true)
    public PixelOrientation getPointInPixel() {
        return this.pointInPixel;
    }

    public void setPointInPixel(PixelOrientation newValue) {
        this.checkWritePermission(this.pointInPixel);
        this.pointInPixel = newValue;
    }

    @XmlElement(name="transformationDimensionDescription")
    public InternationalString getTransformationDimensionDescription() {
        return this.transformationDimensionDescription;
    }

    public void setTransformationDimensionDescription(InternationalString newValue) {
        this.checkWritePermission(this.transformationDimensionDescription);
        this.transformationDimensionDescription = newValue;
    }

    @XmlElement(name="transformationDimensionMapping")
    public Collection<InternationalString> getTransformationDimensionMapping() {
        this.transformationDimensionMapping = this.nonNullCollection(this.transformationDimensionMapping, InternationalString.class);
        return this.transformationDimensionMapping;
    }

    public void setTransformationDimensionMapping(Collection<? extends InternationalString> newValues) {
        this.transformationDimensionMapping = this.writeCollection(newValues, this.transformationDimensionMapping, InternationalString.class);
    }

    @XmlElement(name="checkPoint")
    public Collection<GCP> getCheckPoints() {
        this.checkPoints = this.nonNullCollection(this.checkPoints, GCP.class);
        return this.checkPoints;
    }

    public void setCheckPoints(Collection<? extends GCP> newValues) {
        this.checkPoints = this.writeCollection(newValues, this.checkPoints, GCP.class);
    }
}

