/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.contractgen;

import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ws.rs.Path;
import org.apache.servicecomb.provider.pojo.RpcSchema;
import org.apache.servicecomb.provider.rest.common.RestSchema;
import org.apache.servicecomb.toolkit.ContractsGenerator;
import org.apache.servicecomb.toolkit.common.ContractFileType;
import org.apache.servicecomb.toolkit.common.ImmediateClassLoader;
import org.apache.servicecomb.toolkit.generator.context.OasGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class DefaultContractsGenerator
implements ContractsGenerator {
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultContractsGenerator.class);
    private Map<String, Object> config;
    private List<String> classpathUrls;
    private String outputDir = ".";
    private ContractFileType contractfileType = ContractFileType.YAML;

    public boolean canProcess(String type) {
        return "default".equals(type);
    }

    public void configure(Map<String, Object> config) {
        Object contractFileTypeObj;
        Object outputDirObj;
        this.config = config;
        if (config == null) {
            return;
        }
        Object classpathUrlsObj = config.get("classpathUrls");
        if (classpathUrlsObj instanceof List) {
            this.classpathUrls = (List)classpathUrlsObj;
        }
        if ((outputDirObj = config.get("outputDir")) instanceof String) {
            this.outputDir = (String)outputDirObj;
        }
        if ((contractFileTypeObj = config.get("contractFileType")) instanceof String) {
            this.contractfileType = ContractFileType.getValue((String)((String)contractFileTypeObj));
        }
    }

    public void generate() throws RuntimeException {
        URL[] runtimeUrls = new URL[this.classpathUrls.size()];
        for (int i = 0; i < this.classpathUrls.size(); ++i) {
            String element = this.classpathUrls.get(i);
            try {
                runtimeUrls[i] = new File(element).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Wrong element in classpath", e);
            }
        }
        if (!this.checkConfig()) {
            throw new IllegalArgumentException("Cannot found configuration");
        }
        ImmediateClassLoader immediateClassLoader = new ImmediateClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
        try {
            Vector allClass = DefaultContractsGenerator.getAllClass((ClassLoader)immediateClassLoader);
            for (int i = 0; i < allClass.size(); ++i) {
                OasGenerator oasGenerator;
                OpenAPI oas;
                Class loadClass = (Class)allClass.get(i);
                if (!DefaultContractsGenerator.canProcess(loadClass) || (oas = (oasGenerator = new OasGenerator()).generate(loadClass)) == null) continue;
                String oasPretty = Yaml.pretty((Object)oas);
                File outputFile = new File(this.outputDir + File.separator + loadClass.getSimpleName() + this.contractfileType.getFileSuffix());
                if (!outputFile.exists()) {
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    outputFile.createNewFile();
                }
                Files.write(Paths.get(outputFile.toURI()), oasPretty.getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkConfig() {
        return this.config != null && this.classpathUrls != null;
    }

    private static boolean canProcess(Class<?> loadClass) {
        if (loadClass == null) {
            return false;
        }
        RestSchema restSchema = loadClass.getAnnotation(RestSchema.class);
        if (restSchema != null) {
            return true;
        }
        RestController controller = loadClass.getAnnotation(RestController.class);
        if (controller != null) {
            return true;
        }
        RpcSchema rpcSchema = loadClass.getAnnotation(RpcSchema.class);
        if (rpcSchema != null) {
            return true;
        }
        RequestMapping requestMapping = loadClass.getAnnotation(RequestMapping.class);
        if (requestMapping != null) {
            return true;
        }
        Path pathAnnotation = loadClass.getAnnotation(Path.class);
        return pathAnnotation != null;
    }

    private static Vector getAllClass(ClassLoader classLoader) {
        try {
            Field classesField = ClassLoader.class.getDeclaredField("classes");
            classesField.setAccessible(true);
            if (classesField.get(classLoader) instanceof Vector) {
                return (Vector)classesField.get(classLoader);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get class from ClassLoader " + classLoader.getClass());
        }
        return new Vector();
    }
}

