/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.diffvalidation.skeleton.schema;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasObjectDiffValidatorTemplate;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.SchemaAddValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.SchemaCompareValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.SchemaDelValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.SchemaDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.util.OasObjectDiffValidatorUtils;

public class SchemaDiffValidatorEngine
extends OasObjectDiffValidatorTemplate<Schema>
implements SchemaDiffValidator {
    private final List<SchemaAddValidator> schemaAddValidators;
    private final List<SchemaDelValidator> schemaDelValidators;
    private final List<SchemaCompareValidator> schemaCompareValidators;

    public SchemaDiffValidatorEngine(List<SchemaAddValidator> schemaAddValidators, List<SchemaDelValidator> schemaDelValidators, List<SchemaCompareValidator> schemaCompareValidators) {
        this.schemaAddValidators = new ArrayList<SchemaAddValidator>(schemaAddValidators);
        this.schemaDelValidators = new ArrayList<SchemaDelValidator>(schemaDelValidators);
        this.schemaCompareValidators = new ArrayList<SchemaCompareValidator>(schemaCompareValidators);
    }

    @Override
    protected List<OasDiffViolation> validateAdd(OasDiffValidationContext context, OasObjectPropertyLocation rightLocation, Schema rightOasObject) {
        return this.schemaAddValidators.stream().map(v -> v.validate(context, rightLocation, rightOasObject)).flatMap(list -> list.stream()).collect(Collectors.toList());
    }

    @Override
    protected List<OasDiffViolation> validateDel(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, Schema leftOasObject) {
        return this.schemaDelValidators.stream().map(v -> v.validate(context, leftLocation, leftOasObject)).flatMap(list -> list.stream()).collect(Collectors.toList());
    }

    @Override
    protected List<OasDiffViolation> validateCompare(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, Schema leftOasObject, OasObjectPropertyLocation rightLocation, Schema rightOasObject) {
        ArrayList<OasDiffViolation> violations = new ArrayList<OasDiffViolation>();
        violations.addAll(this.schemaCompareValidators.stream().map(v -> v.validate(context, leftLocation, leftOasObject, rightLocation, rightOasObject)).flatMap(list -> list.stream()).collect(Collectors.toList()));
        violations.addAll(this.validateCompareOrdinary(context, leftLocation, leftOasObject, rightLocation, rightOasObject));
        violations.addAll(this.validateCompareArray(context, leftLocation, leftOasObject, rightLocation, rightOasObject));
        violations.addAll(this.validateCompareComposed(context, leftLocation, leftOasObject, rightLocation, rightOasObject));
        return violations;
    }

    private List<OasDiffViolation> validateCompareOrdinary(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, Schema leftOasObject, OasObjectPropertyLocation rightLocation, Schema rightOasObject) {
        return OasObjectDiffValidatorUtils.doDiffValidateMapProperty(context, "properties", leftLocation, leftOasObject.getProperties(), rightLocation, rightOasObject.getProperties(), OasObjectType.SCHEMA, Collections.singletonList(this));
    }

    private List<OasDiffViolation> validateCompareArray(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, Schema leftOasObject, OasObjectPropertyLocation rightLocation, Schema rightOasObject) {
        Schema leftItems = null;
        OasObjectPropertyLocation leftItemsLocation = null;
        if (leftOasObject instanceof ArraySchema) {
            leftItems = ((ArraySchema)leftOasObject).getItems();
            leftItemsLocation = leftLocation.property("items", OasObjectType.SCHEMA);
        }
        Schema rightItems = null;
        OasObjectPropertyLocation rightItemsLocation = null;
        if (rightOasObject instanceof ArraySchema) {
            rightItems = ((ArraySchema)rightOasObject).getItems();
            rightItemsLocation = rightLocation.property("items", OasObjectType.SCHEMA);
        }
        return OasObjectDiffValidatorUtils.doDiffValidateProperty(context, leftItemsLocation, leftItems, rightItemsLocation, rightItems, Collections.singletonList(this));
    }

    private List<OasDiffViolation> validateCompareComposed(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, Schema leftOasObject, OasObjectPropertyLocation rightLocation, Schema rightOasObject) {
        ArrayList<OasDiffViolation> violations = new ArrayList<OasDiffViolation>();
        List leftAllOf = null;
        List leftOneOf = null;
        List leftAnyOf = null;
        if (leftOasObject instanceof ComposedSchema) {
            leftAllOf = ((ComposedSchema)leftOasObject).getAllOf();
            leftOneOf = ((ComposedSchema)leftOasObject).getOneOf();
            leftAnyOf = ((ComposedSchema)leftOasObject).getAnyOf();
        }
        List rightAllOf = null;
        List rightOneOf = null;
        List rightAnyOf = null;
        if (rightOasObject instanceof ComposedSchema) {
            rightAllOf = ((ComposedSchema)rightOasObject).getAllOf();
            rightOneOf = ((ComposedSchema)rightOasObject).getOneOf();
            rightAnyOf = ((ComposedSchema)rightOasObject).getAnyOf();
        }
        violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateListProperty(context, "allOf", leftLocation, leftAllOf, rightLocation, rightAllOf, OasObjectType.SCHEMA, schema -> System.identityHashCode(schema), Collections.singletonList(this)));
        violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateListProperty(context, "oneOf", leftLocation, leftOneOf, rightLocation, rightOneOf, OasObjectType.SCHEMA, schema -> System.identityHashCode(schema), Collections.singletonList(this)));
        violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateListProperty(context, "anyOf", leftLocation, leftAnyOf, rightLocation, rightAnyOf, OasObjectType.SCHEMA, schema -> System.identityHashCode(schema), Collections.singletonList(this)));
        return violations;
    }
}

