/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckPathsBetweenNodes;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Promises;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.TernaryValue;
import javax.annotation.Nullable;

class CheckMissingReturn
implements NodeTraversal.ScopedCallback {
    static final DiagnosticType MISSING_RETURN_STATEMENT = DiagnosticType.warning("JSC_MISSING_RETURN_STATEMENT", "Missing return statement. Function expected to return {0}.");
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private static final Predicate<Node> IS_RETURN = new Predicate<Node>(){

        @Override
        public boolean apply(Node input) {
            return input != null && input.isReturn();
        }
    };
    private static final Predicate<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>> GOES_THROUGH_TRUE_CONDITION_PREDICATE = new Predicate<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>>(){

        @Override
        public boolean apply(DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> input) {
            TernaryValue val;
            Node condition;
            ControlFlowGraph.Branch branch = (ControlFlowGraph.Branch)((Object)input.getValue());
            if (branch == ControlFlowGraph.Branch.ON_EX) {
                return false;
            }
            if (branch.isConditional() && (condition = NodeUtil.getConditionExpression((Node)input.getSource().getValue())) != null && (val = NodeUtil.getImpureBooleanValue(condition)) != TernaryValue.UNKNOWN) {
                return val.toBoolean(true) == (ControlFlowGraph.Branch.ON_TRUE == branch);
            }
            return true;
        }
    };

    CheckMissingReturn(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Node functionBody;
        Node n = t.getScopeRoot();
        JSType returnType = this.getExplicitReturnTypeIfExpected(n);
        if (returnType == null) {
            return;
        }
        if (n.isGeneratorFunction()) {
            return;
        }
        if (n.isArrowFunction() && !(functionBody = NodeUtil.getFunctionBody(n)).isBlock()) {
            return;
        }
        if (this.fastAllPathsReturnCheck(t.getControlFlowGraph())) {
            return;
        }
        CheckPathsBetweenNodes<Node, ControlFlowGraph.Branch> test = new CheckPathsBetweenNodes<Node, ControlFlowGraph.Branch>(t.getControlFlowGraph(), t.getControlFlowGraph().getEntry(), t.getControlFlowGraph().getImplicitReturn(), IS_RETURN, GOES_THROUGH_TRUE_CONDITION_PREDICATE);
        if (!test.allPathsSatisfyPredicate()) {
            this.compiler.report(t.makeError(t.getScopeRoot(), MISSING_RETURN_STATEMENT, returnType.toString()));
        }
    }

    private boolean fastAllPathsReturnCheck(ControlFlowGraph<Node> cfg) {
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> s : cfg.getImplicitReturn().getInEdges()) {
            Node n = (Node)s.getSource().getValue();
            if (n.isReturn() || this.convention.isFunctionCallThatAlwaysThrows(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    @Nullable
    private JSType getExplicitReturnTypeIfExpected(Node scopeRoot) {
        if (!scopeRoot.isFunction()) {
            return null;
        }
        FunctionType scopeType = JSType.toMaybeFunctionType(scopeRoot.getJSType());
        if (scopeType == null) {
            return null;
        }
        if (CheckMissingReturn.isEmptyFunction(scopeRoot)) {
            return null;
        }
        if (scopeType.isConstructor()) {
            return null;
        }
        JSType returnType = scopeType.getReturnType();
        if (returnType == null) {
            return null;
        }
        if (scopeRoot.isAsyncFunction()) {
            returnType = Promises.getTemplateTypeOfThenable(this.compiler.getTypeRegistry(), returnType);
        }
        if (!this.isVoidOrUnknown(returnType)) {
            return returnType;
        }
        return null;
    }

    private static boolean isEmptyFunction(Node function) {
        return function.getChildCount() == 3 && !function.getSecondChild().getNext().hasChildren();
    }

    private boolean isVoidOrUnknown(JSType returnType) {
        JSType voidType = this.compiler.getTypeRegistry().getNativeType(JSTypeNative.VOID_TYPE);
        return voidType.isSubtypeOf(returnType);
    }
}

