/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.definitions.references;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.internal.definitions.references.BuiltinReference;
import org.apache.royale.compiler.internal.definitions.references.LexicalReference;
import org.apache.royale.compiler.internal.definitions.references.NotATypeReference;
import org.apache.royale.compiler.internal.definitions.references.ParameterizedReference;
import org.apache.royale.compiler.internal.definitions.references.ResolvedQualifiersReference;
import org.apache.royale.compiler.internal.definitions.references.ResolvedReference;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.workspaces.IWorkspace;

public class ReferenceFactory {
    private static final IReference REFERENCE_ANY_TYPE = new BuiltinReference(IASLanguageConstants.BuiltinType.ANY_TYPE);
    private static final IReference REFERENCE_Array = new BuiltinReference(IASLanguageConstants.BuiltinType.ARRAY);
    private static final IReference REFERENCE_Boolean = new BuiltinReference(IASLanguageConstants.BuiltinType.BOOLEAN);
    private static final IReference REFERENCE_Class = new BuiltinReference(IASLanguageConstants.BuiltinType.CLASS);
    private static final IReference REFERENCE_Function = new BuiltinReference(IASLanguageConstants.BuiltinType.FUNCTION);
    private static final IReference REFERENCE_int = new BuiltinReference(IASLanguageConstants.BuiltinType.INT);
    private static final IReference REFERENCE_null = new BuiltinReference(IASLanguageConstants.BuiltinType.NULL);
    private static final IReference REFERENCE_Number = new BuiltinReference(IASLanguageConstants.BuiltinType.NUMBER);
    private static final IReference REFERENCE_Object = new BuiltinReference(IASLanguageConstants.BuiltinType.OBJECT);
    private static final IReference REFERENCE_QName = new BuiltinReference(IASLanguageConstants.BuiltinType.QNAME);
    private static final IReference REFERENCE_RegExp = new BuiltinReference(IASLanguageConstants.BuiltinType.REGEXP);
    private static final IReference REFERENCE_String = new BuiltinReference(IASLanguageConstants.BuiltinType.STRING);
    private static final IReference REFERENCE_undefined = new BuiltinReference(IASLanguageConstants.BuiltinType.Undefined);
    private static final IReference REFERENCE_uint = new BuiltinReference(IASLanguageConstants.BuiltinType.UINT);
    private static final IReference REFERENCE_Vector = new BuiltinReference(IASLanguageConstants.BuiltinType.VECTOR);
    private static final IReference REFERENCE_void = new BuiltinReference(IASLanguageConstants.BuiltinType.VOID);
    private static final IReference REFERENCE_XML = new BuiltinReference(IASLanguageConstants.BuiltinType.XML);
    private static final IReference REFERENCE_XMLList = new BuiltinReference(IASLanguageConstants.BuiltinType.XMLLIST);

    public static IReference builtinReference(IASLanguageConstants.BuiltinType type) {
        switch (type) {
            case ANY_TYPE: {
                return REFERENCE_ANY_TYPE;
            }
            case ARRAY: {
                return REFERENCE_Array;
            }
            case BOOLEAN: {
                return REFERENCE_Boolean;
            }
            case CLASS: {
                return REFERENCE_Class;
            }
            case FUNCTION: {
                return REFERENCE_Function;
            }
            case INT: {
                return REFERENCE_int;
            }
            case NULL: {
                return REFERENCE_null;
            }
            case NUMBER: {
                return REFERENCE_Number;
            }
            case OBJECT: {
                return REFERENCE_Object;
            }
            case QNAME: {
                return REFERENCE_QName;
            }
            case REGEXP: {
                return REFERENCE_RegExp;
            }
            case STRING: {
                return REFERENCE_String;
            }
            case Undefined: {
                return REFERENCE_undefined;
            }
            case UINT: {
                return REFERENCE_uint;
            }
            case VECTOR: {
                return REFERENCE_Vector;
            }
            case VOID: {
                return REFERENCE_void;
            }
            case XML: {
                return REFERENCE_XML;
            }
            case XMLLIST: {
                return REFERENCE_XMLList;
            }
        }
        assert (false) : "Unknown builtin type " + (Object)((Object)type);
        return new BuiltinReference(type);
    }

    public static IReference lexicalReference(IWorkspace workspace, String baseName) {
        if (workspace instanceof Workspace) {
            return ((Workspace)workspace).getReferenceCache().getLexicalReference(baseName);
        }
        return new LexicalReference(baseName);
    }

    public static IResolvedQualifiersReference resolvedQualifierQualifiedReference(IWorkspace workspace, INamespaceDefinition namespace, String baseName) {
        ImmutableSet qualifiers = new ImmutableSet.Builder().add((Object)namespace).build();
        return new ResolvedQualifiersReference((ImmutableSet<INamespaceDefinition>)qualifiers, baseName);
    }

    public static IResolvedQualifiersReference packageQualifiedReference(IWorkspace workspace, String packageName, String baseName, boolean includeInternal) {
        INamespaceDefinition.ILanguageNamespaceDefinition packagePublicNS = ((Workspace)workspace).getPackageNamespaceDefinitionCache().get(packageName, false);
        ImmutableSet.Builder namespaceSetBuilder = new ImmutableSet.Builder().add((Object)packagePublicNS);
        if (includeInternal) {
            INamespaceDefinition.ILanguageNamespaceDefinition packageInternalNS = ((Workspace)workspace).getPackageNamespaceDefinitionCache().get(packageName, true);
            namespaceSetBuilder.add((Object)packageInternalNS);
        }
        ImmutableSet namespaceSet = namespaceSetBuilder.build();
        return new ResolvedQualifiersReference((ImmutableSet<INamespaceDefinition>)namespaceSet, baseName);
    }

    public static IResolvedQualifiersReference packageQualifiedReference(IWorkspace workspace, String qname) {
        return ReferenceFactory.packageQualifiedReference(workspace, qname, false);
    }

    public static IResolvedQualifiersReference packageQualifiedReference(IWorkspace workspace, String qname, boolean includeInternal) {
        int lastIndexOfDot = qname.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            String unqualifiedName = qname.substring(lastIndexOfDot + 1);
            String packageName = qname.substring(0, lastIndexOfDot);
            return ReferenceFactory.packageQualifiedReference(workspace, packageName, unqualifiedName, includeInternal);
        }
        return ReferenceFactory.packageQualifiedReference(workspace, "", qname, includeInternal);
    }

    public static IResolvedQualifiersReference multinameReference(IWorkspace workspace, Set<INamespaceDefinition> namespaces, String baseName) {
        return new ResolvedQualifiersReference((ImmutableSet<INamespaceDefinition>)ImmutableSet.copyOf(namespaces), baseName);
    }

    public static IReference parameterizedReference(IWorkspace workspace, IReference base, IReference param) {
        return new ParameterizedReference(base, param);
    }

    public static IReference resolvedReference(IDefinition definition) {
        return new ResolvedReference(definition);
    }

    public static IReference notATypeReference(IWorkspace workspace, String baseName) {
        return new NotATypeReference(baseName);
    }

    private ReferenceFactory() {
    }
}

