/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.impl.consumer.ConsumeService;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

class FifoConsumeService
extends ConsumeService {
    private static final Logger log = LoggerFactory.getLogger(FifoConsumeService.class);
    private final boolean enableFifoConsumeAccelerator;

    public FifoConsumeService(ClientId clientId, MessageListener messageListener, ThreadPoolExecutor consumptionExecutor, MessageInterceptor messageInterceptor, ScheduledExecutorService scheduler, boolean enableFifoConsumeAccelerator) {
        super(clientId, messageListener, consumptionExecutor, messageInterceptor, scheduler);
        this.enableFifoConsumeAccelerator = enableFifoConsumeAccelerator;
    }

    @Override
    public void consume(ProcessQueue pq, List<MessageViewImpl> messageViews) {
        if (!this.enableFifoConsumeAccelerator || messageViews.size() <= 1) {
            this.consumeIteratively(pq, messageViews.iterator());
            return;
        }
        HashMap<String, List> messageViewsGroupByMessageGroup = new HashMap<String, List>();
        ArrayList<MessageViewImpl> messageViewsWithoutMessageGroup = new ArrayList<MessageViewImpl>();
        for (MessageViewImpl messageView : messageViews) {
            Optional<String> messageGroup = messageView.getMessageGroup();
            if (messageGroup.isPresent()) {
                messageViewsGroupByMessageGroup.computeIfAbsent(messageGroup.get(), k -> new ArrayList()).add(messageView);
                continue;
            }
            messageViewsWithoutMessageGroup.add(messageView);
        }
        log.debug("FifoConsumeService parallel consume, messageViewsNum={}, groupNum={}", (Object)messageViews.size(), (Object)(messageViewsGroupByMessageGroup.size() + (messageViewsWithoutMessageGroup.isEmpty() ? 0 : 1)));
        messageViewsGroupByMessageGroup.values().forEach(list -> this.consumeIteratively(pq, list.iterator()));
        this.consumeIteratively(pq, messageViewsWithoutMessageGroup.iterator());
    }

    public void consumeIteratively(ProcessQueue pq, Iterator<MessageViewImpl> iterator) {
        if (!iterator.hasNext()) {
            return;
        }
        MessageViewImpl messageView = iterator.next();
        if (messageView.isCorrupted()) {
            log.error("Message is corrupted for FIFO consumption, prepare to discard it, mq={}, messageId={}, clientId={}", pq.getMessageQueue(), messageView.getMessageId(), this.clientId);
            pq.discardFifoMessage(messageView);
            this.consumeIteratively(pq, iterator);
            return;
        }
        ListenableFuture<ConsumeResult> future0 = this.consume(messageView);
        ListenableFuture future = Futures.transformAsync(future0, result -> pq.eraseFifoMessage(messageView, (ConsumeResult)((Object)result)), MoreExecutors.directExecutor());
        future.addListener(() -> this.consumeIteratively(pq, iterator), MoreExecutors.directExecutor());
    }
}

