/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.apis;

import java.util.Optional;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;

public class SessionCredentials {
    private final String accessKey;
    private final String accessSecret;
    private final String securityToken;

    public SessionCredentials(String accessKey, String accessSecret, String securityToken) {
        this.accessKey = Preconditions.checkNotNull(accessKey, "accessKey should not be null");
        this.accessSecret = Preconditions.checkNotNull(accessSecret, "accessSecret should not be null");
        this.securityToken = Preconditions.checkNotNull(securityToken, "securityToken should not be null");
    }

    public SessionCredentials(String accessKey, String accessSecret) {
        this.accessKey = Preconditions.checkNotNull(accessKey, "accessKey should not be null");
        this.accessSecret = Preconditions.checkNotNull(accessSecret, "accessSecret should not be null");
        this.securityToken = null;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public Optional<String> tryGetSecurityToken() {
        return null == this.securityToken ? Optional.empty() : Optional.of(this.securityToken);
    }
}

