/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.internal.data;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.concurrent.Immutable;
import org.apache.rocketmq.shaded.com.google.auto.value.AutoValue;
import org.apache.rocketmq.shaded.com.google.auto.value.extension.memoized.Memoized;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.AttributesBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.internal.AttributeUtil;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.SpanLimits;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.internal.data.AutoValue_ImmutableExceptionEventData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.internal.data.ExceptionEventData;
import org.apache.rocketmq.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;

@AutoValue
@Immutable
abstract class ImmutableExceptionEventData
implements ExceptionEventData {
    static ExceptionEventData create(SpanLimits spanLimits, long epochNanos, Throwable exception, Attributes additionalAttributes) {
        return new AutoValue_ImmutableExceptionEventData(epochNanos, exception, additionalAttributes, spanLimits);
    }

    ImmutableExceptionEventData() {
    }

    protected abstract SpanLimits getSpanLimits();

    @Override
    public final String getName() {
        return "exception";
    }

    @Override
    @Memoized
    public Attributes getAttributes() {
        Throwable exception = this.getException();
        Attributes additionalAttributes = this.getAdditionalAttributes();
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesBuilder.put(SemanticAttributes.EXCEPTION_TYPE, exception.getClass().getCanonicalName());
        String message = exception.getMessage();
        if (message != null) {
            attributesBuilder.put(SemanticAttributes.EXCEPTION_MESSAGE, message);
        }
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            exception.printStackTrace(printWriter);
        }
        attributesBuilder.put(SemanticAttributes.EXCEPTION_STACKTRACE, stringWriter.toString());
        attributesBuilder.putAll(additionalAttributes);
        SpanLimits spanLimits = this.getSpanLimits();
        return AttributeUtil.applyAttributesLimit(attributesBuilder.build(), spanLimits.getMaxNumberOfAttributesPerEvent(), spanLimits.getMaxAttributeValueLength());
    }

    @Override
    public final int getTotalAttributeCount() {
        return this.getAttributes().size();
    }
}

