/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.HeartbeatResponse;
import apache.rocketmq.v2.MessageQueue;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.PrintThreadStackTraceCommand;
import apache.rocketmq.v2.QueryRouteRequest;
import apache.rocketmq.v2.QueryRouteResponse;
import apache.rocketmq.v2.RecoverOrphanedTransactionCommand;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.Settings;
import apache.rocketmq.v2.Status;
import apache.rocketmq.v2.TelemetryCommand;
import apache.rocketmq.v2.ThreadStackTrace;
import apache.rocketmq.v2.VerifyMessageCommand;
import apache.rocketmq.v2.VerifyMessageResult;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.java.exception.BadRequestException;
import org.apache.rocketmq.client.java.exception.InternalErrorException;
import org.apache.rocketmq.client.java.exception.NotFoundException;
import org.apache.rocketmq.client.java.exception.ProxyTimeoutException;
import org.apache.rocketmq.client.java.exception.TooManyRequestsException;
import org.apache.rocketmq.client.java.exception.UnsupportedException;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.impl.Client;
import org.apache.rocketmq.client.java.impl.ClientManager;
import org.apache.rocketmq.client.java.impl.ClientManagerImpl;
import org.apache.rocketmq.client.java.impl.ClientSessionImpl;
import org.apache.rocketmq.client.java.impl.ClientSettings;
import org.apache.rocketmq.client.java.impl.producer.ClientSessionHandler;
import org.apache.rocketmq.client.java.message.MessageCommon;
import org.apache.rocketmq.client.java.metrics.ClientMeterProvider;
import org.apache.rocketmq.client.java.metrics.Metric;
import org.apache.rocketmq.client.java.misc.ExecutorServices;
import org.apache.rocketmq.client.java.misc.ThreadFactoryImpl;
import org.apache.rocketmq.client.java.misc.Utilities;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.TopicRouteData;
import org.apache.rocketmq.client.java.rpc.RpcInvocation;
import org.apache.rocketmq.client.java.rpc.Signature;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;
import org.apache.rocketmq.shaded.com.google.common.collect.Sets;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.AbstractIdleService;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.rocketmq.shaded.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.apache.rocketmq.shaded.io.grpc.Metadata;
import org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public abstract class ClientImpl
extends AbstractIdleService
implements Client,
ClientSessionHandler,
MessageInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientImpl.class);
    private static final Duration TELEMETRY_TIMEOUT = Duration.ofDays(21900L);
    protected final ClientManager clientManager;
    protected final ClientConfiguration clientConfiguration;
    protected final Endpoints endpoints;
    protected final Set<String> topics;
    protected final Set<Endpoints> isolated;
    protected final ExecutorService clientCallbackExecutor;
    protected final ClientMeterProvider clientMeterProvider;
    protected final ThreadPoolExecutor telemetryCommandExecutor;
    protected final String clientId;
    private volatile ScheduledFuture<?> updateRouteCacheFuture;
    private final ConcurrentMap<String, TopicRouteData> topicRouteCache;
    @GuardedBy(value="inflightRouteFutureLock")
    private final Map<String, Set<SettableFuture<TopicRouteData>>> inflightRouteFutureTable;
    private final Lock inflightRouteFutureLock;
    @GuardedBy(value="sessionsLock")
    private final Map<Endpoints, ClientSessionImpl> sessionsTable;
    private final ReadWriteLock sessionsLock;
    @GuardedBy(value="messageInterceptorsLock")
    private final List<MessageInterceptor> messageInterceptors;
    private final ReadWriteLock messageInterceptorsLock;

    public ClientImpl(ClientConfiguration clientConfiguration, Set<String> topics) {
        this.clientConfiguration = Preconditions.checkNotNull(clientConfiguration, "clientConfiguration should not be null");
        this.endpoints = new Endpoints(clientConfiguration.getEndpoints());
        this.topics = topics;
        this.clientId = Utilities.genClientId();
        this.topicRouteCache = new ConcurrentHashMap<String, TopicRouteData>();
        this.inflightRouteFutureTable = new ConcurrentHashMap<String, Set<SettableFuture<TopicRouteData>>>();
        this.inflightRouteFutureLock = new ReentrantLock();
        this.sessionsTable = new HashMap<Endpoints, ClientSessionImpl>();
        this.sessionsLock = new ReentrantReadWriteLock();
        this.isolated = Collections.newSetFromMap(new ConcurrentHashMap());
        this.messageInterceptors = new ArrayList<MessageInterceptor>();
        this.messageInterceptorsLock = new ReentrantReadWriteLock();
        this.clientManager = new ClientManagerImpl(this);
        this.clientCallbackExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("ClientCallbackWorker"));
        this.clientMeterProvider = new ClientMeterProvider(this);
        this.telemetryCommandExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("CommandExecutor"));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.info("JVM shutdown hook is invoked, clientId={}, state={}", (Object)this.clientId, (Object)this.state());
            this.stopAsync().awaitTerminated();
        }));
    }

    @Override
    protected void startUp() throws Exception {
        LOGGER.info("Begin to start the rocketmq client, clientId={}", (Object)this.clientId);
        this.clientManager.startAsync().awaitRunning();
        LOGGER.info("Begin to fetch topic(s) route data from remote during client startup, clientId={}, topics={}", (Object)this.clientId, (Object)this.topics);
        List futures = this.topics.stream().map(this::fetchTopicRoute).collect(Collectors.toList());
        for (ListenableFuture future : futures) {
            future.get();
        }
        LOGGER.info("Fetch topic route data from remote successfully during startup, clientId={}, topics={}", (Object)this.clientId, (Object)this.topics);
        ScheduledExecutorService scheduler = this.clientManager.getScheduler();
        this.updateRouteCacheFuture = scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.updateRouteCache();
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised while updating topic route cache, clientId={}", (Object)this.clientId, (Object)t);
            }
        }, 10L, 30L, TimeUnit.SECONDS);
        LOGGER.info("The rocketmq client starts successfully, clientId={}", (Object)this.clientId);
    }

    @Override
    protected void shutDown() throws InterruptedException {
        LOGGER.info("Begin to shutdown the rocketmq client, clientId={}", (Object)this.clientId);
        this.notifyClientTermination();
        if (null != this.updateRouteCacheFuture) {
            this.updateRouteCacheFuture.cancel(false);
        }
        this.telemetryCommandExecutor.shutdown();
        if (!ExecutorServices.awaitTerminated(this.telemetryCommandExecutor)) {
            LOGGER.error("[Bug] Timeout to shutdown the telemetry command executor, clientId={}", (Object)this.clientId);
        } else {
            LOGGER.info("Shutdown the telemetry command executor successfully, clientId={}", (Object)this.clientId);
        }
        LOGGER.info("Begin to release telemetry sessions, clientId={}", (Object)this.clientId);
        this.releaseClientSessions();
        LOGGER.info("Release telemetry sessions successfully, clientId={}", (Object)this.clientId);
        this.clientManager.stopAsync().awaitTerminated();
        this.clientCallbackExecutor.shutdown();
        if (!ExecutorServices.awaitTerminated(this.clientCallbackExecutor)) {
            LOGGER.error("[Bug] Timeout to shutdown the client callback executor, clientId={}", (Object)this.clientId);
        }
        LOGGER.info("Shutdown the rocketmq client successfully, clientId={}", (Object)this.clientId);
    }

    public void registerMessageInterceptor(MessageInterceptor messageInterceptor) {
        this.messageInterceptorsLock.writeLock().lock();
        try {
            this.messageInterceptors.add(messageInterceptor);
        }
        finally {
            this.messageInterceptorsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doBefore(MessageHookPoints hookPoint, List<MessageCommon> messageCommons) {
        this.messageInterceptorsLock.readLock().lock();
        try {
            for (MessageInterceptor interceptor : this.messageInterceptors) {
                try {
                    interceptor.doBefore(hookPoint, messageCommons);
                }
                catch (Throwable t) {
                    LOGGER.warn("Exception raised while intercepting message, hookPoint={}, clientId={}", (Object)hookPoint, (Object)this.clientId);
                }
            }
        }
        finally {
            this.messageInterceptorsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAfter(MessageHookPoints hookPoints, List<MessageCommon> messageCommons, Duration duration, MessageHookPointsStatus status) {
        this.messageInterceptorsLock.readLock().lock();
        try {
            for (MessageInterceptor interceptor : this.messageInterceptors) {
                try {
                    interceptor.doAfter(hookPoints, messageCommons, duration, status);
                }
                catch (Throwable t) {
                    LOGGER.warn("Exception raised while intercepting message, hookPoint={}, clientId={}", (Object)hookPoints, (Object)this.clientId);
                }
            }
        }
        finally {
            this.messageInterceptorsLock.readLock().unlock();
        }
    }

    @Override
    public TelemetryCommand settingsCommand() {
        Settings settings = this.getClientSettings().toProtobuf();
        return TelemetryCommand.newBuilder().setSettings(settings).build();
    }

    @Override
    public StreamObserver<TelemetryCommand> telemetry(Endpoints endpoints, StreamObserver<TelemetryCommand> observer) throws ClientException {
        try {
            Metadata metadata = this.sign();
            return this.clientManager.telemetry(endpoints, metadata, TELEMETRY_TIMEOUT, observer);
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InternalErrorException(t);
        }
    }

    @Override
    public boolean isEndpointsDeprecated(Endpoints endpoints) {
        Set<Endpoints> totalRouteEndpoints = this.getTotalRouteEndpoints();
        return !totalRouteEndpoints.contains(endpoints);
    }

    @Override
    public ListenableFuture<Void> awaitSettingSynchronized() {
        return Futures.transformAsync(this.getClientSettings().arrivedFuture, clientSettings -> Futures.immediateVoidFuture(), this.clientCallbackExecutor);
    }

    @Override
    public void onPrintThreadStackTraceCommand(Endpoints endpoints, PrintThreadStackTraceCommand command) {
        String nonce = command.getNonce();
        Runnable task = () -> {
            try {
                String stackTrace = Utilities.stackTrace();
                Status status = Status.newBuilder().setCode(Code.OK).build();
                ThreadStackTrace threadStackTrace = ThreadStackTrace.newBuilder().setThreadStackTrace(stackTrace).setNonce(command.getNonce()).build();
                TelemetryCommand telemetryCommand = TelemetryCommand.newBuilder().setThreadStackTrace(threadStackTrace).setStatus(status).build();
                this.telemetry(endpoints, telemetryCommand);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to send thread stack trace to remote, endpoints={}, nonce={}, clientId={}", endpoints, nonce, this.clientId, t);
            }
        };
        try {
            this.telemetryCommandExecutor.submit(task);
        }
        catch (Throwable t) {
            LOGGER.error("[Bug] Exception raised while submitting task to print thread stack trace, endpoints={}, nonce={}, clientId={}", endpoints, nonce, this.clientId, t);
        }
    }

    public abstract ClientSettings getClientSettings();

    @Override
    public final void onSettingsCommand(Endpoints endpoints, Settings settings) {
        Metric metric = new Metric(settings.getMetric());
        this.clientMeterProvider.reset(metric);
        this.getClientSettings().applySettingsCommand(settings);
    }

    @Override
    public void syncSettings() {
        Settings settings = this.getClientSettings().toProtobuf();
        TelemetryCommand command = TelemetryCommand.newBuilder().setSettings(settings).build();
        Set<Endpoints> totalRouteEndpoints = this.getTotalRouteEndpoints();
        for (Endpoints endpoints : totalRouteEndpoints) {
            try {
                this.telemetry(endpoints, command);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to telemeter settings, clientId={}, endpoints={}", this.clientId, endpoints, t);
            }
        }
    }

    public void telemetry(Endpoints endpoints, TelemetryCommand command) {
        try {
            ClientSessionImpl clientSession = this.getClientSession(endpoints);
            clientSession.fireWrite(command);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to fire write telemetry command, clientId={}, endpoints={}", this.clientId, endpoints, t);
        }
    }

    private void releaseClientSessions() {
        this.sessionsLock.readLock().lock();
        try {
            this.sessionsTable.values().forEach(ClientSessionImpl::release);
        }
        finally {
            this.sessionsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSessionImpl getClientSession(Endpoints endpoints) throws ClientException {
        ClientSessionImpl session;
        this.sessionsLock.readLock().lock();
        try {
            session = this.sessionsTable.get(endpoints);
            if (null != session) {
                ClientSessionImpl clientSessionImpl = session;
                return clientSessionImpl;
            }
        }
        finally {
            this.sessionsLock.readLock().unlock();
        }
        this.sessionsLock.writeLock().lock();
        try {
            session = this.sessionsTable.get(endpoints);
            if (null != session) {
                ClientSessionImpl clientSessionImpl = session;
                return clientSessionImpl;
            }
            session = new ClientSessionImpl(this, endpoints);
            this.sessionsTable.put(endpoints, session);
            ClientSessionImpl clientSessionImpl = session;
            return clientSessionImpl;
        }
        finally {
            this.sessionsLock.writeLock().unlock();
        }
    }

    private ListenableFuture<Void> syncSettingsSafely(Endpoints endpoints) {
        try {
            ClientSessionImpl clientSession = this.getClientSession(endpoints);
            return clientSession.syncSettingsSafely();
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture(t);
        }
    }

    public ListenableFuture<TopicRouteData> onTopicRouteDataFetched(String topic, TopicRouteData topicRouteData) {
        Set routeEndpoints = topicRouteData.getMessageQueues().stream().map(mq -> mq.getBroker().getEndpoints()).collect(Collectors.toSet());
        Set<Endpoints> existRouteEndpoints = this.getTotalRouteEndpoints();
        HashSet newEndpoints = new HashSet(Sets.difference(routeEndpoints, existRouteEndpoints));
        List futures = newEndpoints.stream().map(this::syncSettingsSafely).collect(Collectors.toList());
        return Futures.whenAllSucceed(futures).callAsync(() -> {
            this.topicRouteCache.put(topic, topicRouteData);
            this.onTopicRouteDataUpdate0(topic, topicRouteData);
            return Futures.immediateFuture(topicRouteData);
        }, this.clientCallbackExecutor);
    }

    public void onTopicRouteDataUpdate0(String topic, TopicRouteData topicRouteData) {
    }

    @Override
    public void onVerifyMessageCommand(Endpoints endpoints, VerifyMessageCommand command) {
        LOGGER.warn("Ignore verify message command from remote, which is not expected, clientId={}, command={}", (Object)this.clientId, (Object)command);
        String nonce = command.getNonce();
        Status status = Status.newBuilder().setCode(Code.NOT_IMPLEMENTED).build();
        VerifyMessageResult verifyMessageResult = VerifyMessageResult.newBuilder().setNonce(nonce).build();
        TelemetryCommand telemetryCommand = TelemetryCommand.newBuilder().setVerifyMessageResult(verifyMessageResult).setStatus(status).build();
        try {
            this.telemetry(endpoints, telemetryCommand);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to send message verification result, clientId={}", (Object)this.clientId, (Object)t);
        }
    }

    @Override
    public void onRecoverOrphanedTransactionCommand(Endpoints endpoints, RecoverOrphanedTransactionCommand command) {
        LOGGER.warn("Ignore orphaned transaction recovery command from remote, which is not expected, clientId={}, command={}", (Object)this.clientId, (Object)command);
    }

    private void updateRouteCache() {
        LOGGER.info("Start to update route cache for a new round, clientId={}", (Object)this.clientId);
        this.topicRouteCache.keySet().forEach(topic -> {
            ListenableFuture<TopicRouteData> future = this.fetchTopicRoute((String)topic);
            Futures.addCallback(future, new FutureCallback<TopicRouteData>(){

                @Override
                public void onSuccess(TopicRouteData topicRouteData) {
                }

                @Override
                public void onFailure(Throwable t) {
                    LOGGER.error("Failed to fetch topic route for update cache, topic={}, clientId={}", topic, ClientImpl.this.clientId, t);
                }
            }, MoreExecutors.directExecutor());
        });
    }

    public abstract NotifyClientTerminationRequest wrapNotifyClientTerminationRequest();

    private void notifyClientTermination() {
        LOGGER.info("Notify remote that client is terminated, clientId={}", (Object)this.clientId);
        Set<Endpoints> routeEndpointsSet = this.getTotalRouteEndpoints();
        NotifyClientTerminationRequest notifyClientTerminationRequest = this.wrapNotifyClientTerminationRequest();
        try {
            Metadata metadata = this.sign();
            for (Endpoints endpoints : routeEndpointsSet) {
                this.clientManager.notifyClientTermination(endpoints, metadata, notifyClientTerminationRequest, this.clientConfiguration.getRequestTimeout());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Exception raised while notifying client's termination, clientId={}", (Object)this.clientId, (Object)t);
        }
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public void doHeartbeat() {
        Set<Endpoints> totalEndpoints = this.getTotalRouteEndpoints();
        HeartbeatRequest request = this.wrapHeartbeatRequest();
        for (Endpoints endpoints : totalEndpoints) {
            this.doHeartbeat(request, endpoints);
        }
    }

    protected Metadata sign() throws NoSuchAlgorithmException, InvalidKeyException {
        return Signature.sign(this.clientConfiguration, this.clientId);
    }

    private void doHeartbeat(HeartbeatRequest request, final Endpoints endpoints) {
        try {
            Metadata metadata = this.sign();
            ListenableFuture<RpcInvocation<HeartbeatResponse>> future = this.clientManager.heartbeat(endpoints, metadata, request, this.clientConfiguration.getRequestTimeout());
            Futures.addCallback(future, new FutureCallback<RpcInvocation<HeartbeatResponse>>(){

                @Override
                public void onSuccess(RpcInvocation<HeartbeatResponse> inv) {
                    HeartbeatResponse response = inv.getResponse();
                    Status status = response.getStatus();
                    Code code = status.getCode();
                    if (Code.OK != code) {
                        LOGGER.warn("Failed to send heartbeat, code={}, status message=[{}], endpoints={}, clientId={}", code, status.getMessage(), endpoints, ClientImpl.this.clientId);
                        return;
                    }
                    LOGGER.info("Send heartbeat successfully, endpoints={}, clientId={}", (Object)endpoints, (Object)ClientImpl.this.clientId);
                    boolean removed = ClientImpl.this.isolated.remove(endpoints);
                    if (removed) {
                        LOGGER.info("Rejoin endpoints which is isolated before, clientId={}, endpoints={}", (Object)ClientImpl.this.clientId, (Object)endpoints);
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    LOGGER.warn("Failed to send heartbeat, endpoints={}, clientId={}", endpoints, ClientImpl.this.clientId, t);
                }
            }, MoreExecutors.directExecutor());
        }
        catch (Throwable e) {
            LOGGER.error("Exception raised while preparing heartbeat, endpoints={}, clientId={}", endpoints, this.clientId, e);
        }
    }

    public abstract HeartbeatRequest wrapHeartbeatRequest();

    @Override
    public void doStats() {
    }

    private ListenableFuture<TopicRouteData> fetchTopicRoute(final String topic) {
        ListenableFuture<TopicRouteData> future = Futures.transformAsync(this.fetchTopicRoute0(topic), topicRouteData -> this.onTopicRouteDataFetched(topic, (TopicRouteData)topicRouteData), MoreExecutors.directExecutor());
        Futures.addCallback(future, new FutureCallback<TopicRouteData>(){

            @Override
            public void onSuccess(TopicRouteData topicRouteData) {
                LOGGER.info("Fetch topic route successfully, clientId={}, topic={}, topicRouteData={}", ClientImpl.this.clientId, topic, topicRouteData);
            }

            @Override
            public void onFailure(Throwable t) {
                LOGGER.error("Failed to fetch topic route, clientId={}, topic={}", ClientImpl.this.clientId, topic, t);
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    private ListenableFuture<TopicRouteData> fetchTopicRoute0(String topic) {
        try {
            Resource topicResource = Resource.newBuilder().setName(topic).build();
            QueryRouteRequest request = QueryRouteRequest.newBuilder().setTopic(topicResource).setEndpoints(this.endpoints.toProtobuf()).build();
            Metadata metadata = this.sign();
            ListenableFuture<RpcInvocation<QueryRouteResponse>> future = this.clientManager.queryRoute(this.endpoints, metadata, request, this.clientConfiguration.getRequestTimeout());
            return Futures.transformAsync(future, invocation -> {
                QueryRouteResponse response = (QueryRouteResponse)invocation.getResponse();
                String requestId = invocation.getContext().getRequestId();
                Status status = response.getStatus();
                String statusMessage = status.getMessage();
                Code code = status.getCode();
                int codeNumber = code.getNumber();
                switch (code) {
                    case OK: {
                        break;
                    }
                    case BAD_REQUEST: 
                    case ILLEGAL_ACCESS_POINT: 
                    case ILLEGAL_TOPIC: 
                    case CLIENT_ID_REQUIRED: {
                        throw new BadRequestException(codeNumber, requestId, statusMessage);
                    }
                    case NOT_FOUND: 
                    case TOPIC_NOT_FOUND: {
                        throw new NotFoundException(codeNumber, requestId, statusMessage);
                    }
                    case TOO_MANY_REQUESTS: {
                        throw new TooManyRequestsException(codeNumber, requestId, statusMessage);
                    }
                    case INTERNAL_ERROR: 
                    case INTERNAL_SERVER_ERROR: {
                        throw new InternalErrorException(codeNumber, requestId, statusMessage);
                    }
                    case PROXY_TIMEOUT: {
                        throw new ProxyTimeoutException(codeNumber, requestId, statusMessage);
                    }
                    default: {
                        throw new UnsupportedException(codeNumber, requestId, statusMessage);
                    }
                }
                List<MessageQueue> messageQueuesList = response.getMessageQueuesList();
                TopicRouteData topicRouteData = new TopicRouteData(messageQueuesList);
                return Futures.immediateFuture(topicRouteData);
            }, MoreExecutors.directExecutor());
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture(t);
        }
    }

    protected Set<Endpoints> getTotalRouteEndpoints() {
        HashSet<Endpoints> totalRouteEndpoints = new HashSet<Endpoints>();
        for (TopicRouteData topicRouteData : this.topicRouteCache.values()) {
            totalRouteEndpoints.addAll(topicRouteData.getTotalEndpoints());
        }
        return totalRouteEndpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenableFuture<TopicRouteData> getRouteData(final String topic) {
        SettableFuture<TopicRouteData> future0 = SettableFuture.create();
        TopicRouteData topicRouteData = (TopicRouteData)this.topicRouteCache.get(topic);
        if (null != topicRouteData) {
            future0.set(topicRouteData);
            return future0;
        }
        this.inflightRouteFutureLock.lock();
        try {
            topicRouteData = (TopicRouteData)this.topicRouteCache.get(topic);
            if (null != topicRouteData) {
                future0.set(topicRouteData);
                SettableFuture<TopicRouteData> settableFuture = future0;
                return settableFuture;
            }
            Set<SettableFuture<TopicRouteData>> inflightFutures = this.inflightRouteFutureTable.get(topic);
            if (null != inflightFutures) {
                inflightFutures.add(future0);
                SettableFuture<TopicRouteData> settableFuture = future0;
                return settableFuture;
            }
            inflightFutures = new HashSet<SettableFuture<TopicRouteData>>();
            inflightFutures.add(future0);
            this.inflightRouteFutureTable.put(topic, inflightFutures);
        }
        finally {
            this.inflightRouteFutureLock.unlock();
        }
        ListenableFuture<TopicRouteData> future = this.fetchTopicRoute(topic);
        Futures.addCallback(future, new FutureCallback<TopicRouteData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(TopicRouteData topicRouteData) {
                ClientImpl.this.inflightRouteFutureLock.lock();
                try {
                    Set newFutureSet = (Set)ClientImpl.this.inflightRouteFutureTable.remove(topic);
                    if (null == newFutureSet) {
                        LOGGER.error("[Bug] in-flight route futures was empty, topic={}, clientId={}", (Object)topic, (Object)ClientImpl.this.clientId);
                        return;
                    }
                    LOGGER.debug("Fetch topic route successfully, topic={}, in-flight route future size={}, clientId={}", topic, newFutureSet.size(), ClientImpl.this.clientId);
                    for (SettableFuture newFuture : newFutureSet) {
                        newFuture.set(topicRouteData);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("[Bug] Exception raised while update route data, topic={}, clientId={}", topic, ClientImpl.this.clientId, t);
                }
                finally {
                    ClientImpl.this.inflightRouteFutureLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Throwable t) {
                ClientImpl.this.inflightRouteFutureLock.lock();
                try {
                    Set newFutureSet = (Set)ClientImpl.this.inflightRouteFutureTable.remove(topic);
                    if (null == newFutureSet) {
                        LOGGER.error("[Bug] in-flight route futures was empty, topic={}, clientId={}", (Object)topic, (Object)ClientImpl.this.clientId);
                        return;
                    }
                    LOGGER.debug("Failed to fetch topic route, topic={}, in-flight route future size={}, clientId={}", topic, newFutureSet.size(), ClientImpl.this.clientId, t);
                    for (SettableFuture future : newFutureSet) {
                        future.setException(t);
                    }
                }
                finally {
                    ClientImpl.this.inflightRouteFutureLock.unlock();
                }
            }
        }, MoreExecutors.directExecutor());
        return future0;
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.clientManager.getScheduler();
    }

    protected <T> T handleClientFuture(ListenableFuture<T> future) throws ClientException {
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClientException) {
                throw (ClientException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ClientException(null == cause ? e : cause);
        }
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }
}

