/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.command;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.retry.ExponentialBackoffRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.thirdparty.com.google.common.io.Closer;
import org.apache.ratis.util.TimeDuration;

public final class Context
implements Closeable {
    private static final TimeDuration DEFAULT_REQUEST_TIMEOUT = TimeDuration.valueOf((long)15L, (TimeUnit)TimeUnit.SECONDS);
    private static final RetryPolicy DEFAULT_RETRY_POLICY = ExponentialBackoffRetry.newBuilder().setBaseSleepTime(TimeDuration.valueOf((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)).setMaxAttempts(10).setMaxSleepTime(TimeDuration.valueOf((long)100000L, (TimeUnit)TimeUnit.MILLISECONDS)).build();
    private final PrintStream mPrintStream;
    private final Closer mCloser = Closer.create();
    private final boolean cli;
    private final RetryPolicy retryPolicy;
    private final RaftProperties properties;
    private final Parameters parameters;

    public Context(PrintStream printStream) {
        this(printStream, true, DEFAULT_RETRY_POLICY, new RaftProperties(), null);
    }

    public Context(PrintStream printStream, boolean cli, RetryPolicy retryPolicy, RaftProperties properties, Parameters parameters) {
        this.mPrintStream = (PrintStream)this.mCloser.register((Closeable)Objects.requireNonNull(printStream, "printStream == null"));
        this.cli = cli;
        this.retryPolicy = retryPolicy != null ? retryPolicy : DEFAULT_RETRY_POLICY;
        this.properties = properties != null ? properties : new RaftProperties();
        this.parameters = parameters;
    }

    public PrintStream getPrintStream() {
        return this.mPrintStream;
    }

    public boolean isCli() {
        return this.cli;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public RaftProperties getProperties() {
        return this.properties;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public RaftClient newRaftClient(RaftGroup group) {
        RaftProperties p = this.getProperties();
        if (this.isCli()) {
            RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)p, (TimeDuration)DEFAULT_REQUEST_TIMEOUT);
            Properties sys = System.getProperties();
            sys.stringPropertyNames().forEach(key -> p.set(key, sys.getProperty((String)key)));
        }
        return RaftClient.newBuilder().setRaftGroup(group).setProperties(p).setParameters(this.getParameters()).setRetryPolicy(this.getRetryPolicy()).build();
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }
}

