/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.membership.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.ratis.examples.membership.server.RaftCluster;

public class Console {
    public static final String USAGE_MSG = "Usage: java org.apache.ratis.examples.membership.server.Console [options]\nOptions:\n\tupdate [new_peer_ports]   Update membership to C_new. Separate ports with comma. e.g. update 5100,5101\n\tadd [peer_port]           Add peer with peer_port to raft cluster. e.g. add 5103\n\tremove  [peer_port]       Remove peer with peer_port from raft cluster. e.g. remove 5100\n\tshow                      Show all peers of raft cluster.\n\tincr                      Increment the counter value.\n\tquery                     Query the value of counter.\n\tquit                      Quit.";
    private final Scanner sc = new Scanner(System.in, "UTF-8");
    private final RaftCluster cluster = new RaftCluster();

    private void init() {
        System.out.println("Raft Server Membership Example.");
        System.out.println("Type ports seperated by comma for initial peers. e.g. 5100,5101,5102");
        String[] portArguments = this.commandLineInput()[0].split(",");
        ArrayList<Integer> ports = new ArrayList<Integer>();
        Arrays.stream(portArguments).map(Integer::parseInt).forEach(ports::add);
        try {
            this.cluster.init(ports);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.show();
        System.out.println(USAGE_MSG);
    }

    private void execute() {
        block4: while (true) {
            try {
                while (true) {
                    String[] args;
                    String command;
                    if ((command = (args = this.commandLineInput())[0]).equalsIgnoreCase("show")) {
                        this.show();
                        continue;
                    }
                    if (command.equalsIgnoreCase("add")) {
                        this.add(args, 1);
                        continue;
                    }
                    if (command.equalsIgnoreCase("remove")) {
                        this.remove(args, 1);
                        continue;
                    }
                    if (command.equalsIgnoreCase("update")) {
                        this.update(args, 1);
                        continue;
                    }
                    if (command.equalsIgnoreCase("incr")) {
                        this.cluster.counterIncrement();
                        continue;
                    }
                    if (command.equalsIgnoreCase("query")) {
                        this.cluster.queryCounter();
                        continue;
                    }
                    if (command.equalsIgnoreCase("quit")) break block4;
                    System.out.println(USAGE_MSG);
                }
            }
            catch (Exception e) {
                System.out.println("Get error " + e.getMessage());
                continue;
            }
            break;
        }
        try {
            System.out.println("Closing cluster...");
            this.cluster.close();
            System.out.println("Cluster closed successfully.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void show() {
        this.cluster.show();
    }

    private void add(String[] args, int index) throws IOException {
        int port = Integer.parseInt(args[index]);
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(port);
        ports.addAll(this.cluster.ports());
        this.cluster.update(ports);
    }

    private void remove(String[] args, int index) throws IOException {
        int port = Integer.parseInt(args[index]);
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.addAll(this.cluster.ports());
        if (ports.remove((Object)port)) {
            this.cluster.update(ports);
        } else {
            System.out.println("Invalid port " + port);
        }
    }

    private void update(String[] args, int index) throws IOException {
        String[] portStrArray = args[index].split(",");
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (String portStr : portStrArray) {
            ports.add(Integer.parseInt(portStr));
        }
        this.cluster.update(ports);
    }

    private String[] commandLineInput() {
        System.out.print(">>> ");
        return this.sc.nextLine().split(" ");
    }

    public static void main(String[] args) throws IOException {
        Console console = new Console();
        console.init();
        console.execute();
    }
}

