/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricRegistriesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MetricRegistries.class);
    private static final String DEFAULT_CLASS = "org.apache.ratis.metrics.impl.MetricRegistriesImpl";

    private MetricRegistriesLoader() {
    }

    public static MetricRegistries load() {
        List<MetricRegistries> availableImplementations = MetricRegistriesLoader.getDefinedImplementations();
        return MetricRegistriesLoader.load(availableImplementations);
    }

    @VisibleForTesting
    static MetricRegistries load(List<MetricRegistries> availableImplementations) {
        if (availableImplementations.size() == 1) {
            MetricRegistries impl = availableImplementations.get(0);
            LOG.info("Loaded MetricRegistries " + impl.getClass());
            return impl;
        }
        if (availableImplementations.isEmpty()) {
            try {
                return ReflectionUtils.newInstance(Class.forName(DEFAULT_CLASS).asSubclass(MetricRegistries.class));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (MetricRegistries factory : availableImplementations) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(factory.getClass());
        }
        LOG.warn("Found multiple MetricRegistries implementations: " + sb + ". Using first found implementation: " + availableImplementations.get(0));
        return availableImplementations.get(0);
    }

    private static List<MetricRegistries> getDefinedImplementations() {
        ServiceLoader<MetricRegistries> loader = ServiceLoader.load(MetricRegistries.class, MetricRegistries.class.getClassLoader());
        ArrayList<MetricRegistries> availableFactories = new ArrayList<MetricRegistries>();
        for (MetricRegistries impl : loader) {
            availableFactories.add(impl);
        }
        return availableFactories;
    }
}

