/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.metrics.intercept.server;

import java.io.Closeable;
import java.util.function.Supplier;
import org.apache.ratis.grpc.metrics.MessageMetrics;
import org.apache.ratis.grpc.metrics.intercept.server.MetricServerCall;
import org.apache.ratis.grpc.metrics.intercept.server.MetricServerCallListener;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.io.grpc.Metadata;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;
import org.apache.ratis.thirdparty.io.grpc.ServerCall;
import org.apache.ratis.thirdparty.io.grpc.ServerCallHandler;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptor;

public class MetricServerInterceptor
implements ServerInterceptor,
Closeable {
    private String identifier;
    private MessageMetrics metrics;
    private final Supplier<RaftPeerId> peerIdSupplier;
    private final String defaultIdentifier;

    public MessageMetrics getMetrics() {
        return this.metrics;
    }

    public MetricServerInterceptor(Supplier<RaftPeerId> idSupplier, String defaultIdentifier) {
        this.peerIdSupplier = idSupplier;
        this.identifier = null;
        this.defaultIdentifier = defaultIdentifier;
    }

    private String getMethodMetricPrefix(MethodDescriptor<?, ?> method) {
        String serviceName = MethodDescriptor.extractFullServiceName(method.getFullMethodName());
        String methodName = method.getFullMethodName().substring(serviceName.length() + 1);
        return this.identifier + "_" + serviceName + "_" + methodName;
    }

    public <R, S> ServerCall.Listener<R> interceptCall(ServerCall<R, S> call, Metadata requestHeaders, ServerCallHandler<R, S> next) {
        MethodDescriptor<R, S> method = call.getMethodDescriptor();
        if (this.identifier == null) {
            try {
                this.identifier = this.peerIdSupplier.get().toString();
            }
            catch (Exception e) {
                this.identifier = this.defaultIdentifier;
            }
        }
        if (this.metrics == null) {
            this.metrics = new MessageMetrics(this.identifier, "server");
        }
        String metricNamePrefix = this.getMethodMetricPrefix(method);
        MetricServerCall<R, S> monitoringCall = new MetricServerCall<R, S>(call, metricNamePrefix, this.metrics);
        return new MetricServerCallListener<R>(next.startCall(monitoringCall, requestHeaders), this.metrics);
    }

    @Override
    public void close() {
        MessageMetrics m4 = this.metrics;
        if (m4 != null) {
            m4.unregister();
        }
    }
}

