/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import net.sf.log4jdbc.ConnectionSpy;
import net.sf.log4jdbc.DriverSpy;
import net.sf.log4jdbc.Spy;
import net.sf.log4jdbc.SpyLogDelegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jSpyLogDelegator
implements SpyLogDelegator {
    private final Logger jdbcLogger = LoggerFactory.getLogger((String)"jdbc.audit");
    private final Logger resultSetLogger = LoggerFactory.getLogger((String)"jdbc.resultset");
    private final Logger sqlOnlyLogger = LoggerFactory.getLogger((String)"jdbc.sqlonly");
    private final Logger sqlTimingLogger = LoggerFactory.getLogger((String)"jdbc.sqltiming");
    private final Logger connectionLogger = LoggerFactory.getLogger((String)"jdbc.connection");
    private final Logger debugLogger = LoggerFactory.getLogger((String)"log4jdbc.debug");
    private static String nl = System.getProperty("line.separator");

    public boolean isJdbcLoggingEnabled() {
        return this.jdbcLogger.isErrorEnabled() || this.resultSetLogger.isErrorEnabled() || this.sqlOnlyLogger.isErrorEnabled() || this.sqlTimingLogger.isErrorEnabled() || this.connectionLogger.isErrorEnabled();
    }

    public void exceptionOccured(Spy spy, String methodCall, Exception e, String sql, long execTime) {
        String classType = spy.getClassType();
        Integer spyNo = spy.getConnectionNumber();
        String header = spyNo + ". " + classType + "." + methodCall;
        if (sql == null) {
            this.jdbcLogger.error(header, (Throwable)e);
            this.sqlOnlyLogger.error(header, (Throwable)e);
            this.sqlTimingLogger.error(header, (Throwable)e);
        } else {
            sql = this.processSql(sql);
            this.jdbcLogger.error(header + " " + sql, (Throwable)e);
            if (this.sqlOnlyLogger.isDebugEnabled()) {
                this.sqlOnlyLogger.error(Slf4jSpyLogDelegator.getDebugInfo() + nl + spyNo + ". " + sql, (Throwable)e);
            } else {
                this.sqlOnlyLogger.error(header + " " + sql, (Throwable)e);
            }
            if (this.sqlTimingLogger.isDebugEnabled()) {
                this.sqlTimingLogger.error(Slf4jSpyLogDelegator.getDebugInfo() + nl + spyNo + ". " + sql + " {FAILED after " + execTime + " msec}", (Throwable)e);
            } else {
                this.sqlTimingLogger.error(header + " FAILED! " + sql + " {FAILED after " + execTime + " msec}", (Throwable)e);
            }
        }
    }

    public void methodReturned(Spy spy, String methodCall, String returnMsg) {
        Logger logger;
        String classType = spy.getClassType();
        Logger logger2 = logger = "ResultSet".equals(classType) ? this.resultSetLogger : this.jdbcLogger;
        if (logger.isInfoEnabled()) {
            String header = spy.getConnectionNumber() + ". " + classType + "." + methodCall + " returned " + returnMsg;
            if (logger.isDebugEnabled()) {
                logger.debug(header + " " + Slf4jSpyLogDelegator.getDebugInfo());
            } else {
                logger.info(header);
            }
        }
    }

    public void constructorReturned(Spy spy, String constructionInfo) {
    }

    private boolean shouldSqlBeLogged(String sql) {
        if (sql == null) {
            return false;
        }
        if ((sql = sql.trim()).length() < 6) {
            return false;
        }
        sql = sql.substring(0, 6).toLowerCase();
        return DriverSpy.DumpSqlSelect && "select".equals(sql) || DriverSpy.DumpSqlInsert && "insert".equals(sql) || DriverSpy.DumpSqlUpdate && "update".equals(sql) || DriverSpy.DumpSqlDelete && "delete".equals(sql) || DriverSpy.DumpSqlCreate && "create".equals(sql);
    }

    public void sqlOccured(Spy spy, String methodCall, String sql) {
        if (!DriverSpy.DumpSqlFilteringOn || this.shouldSqlBeLogged(sql)) {
            if (this.sqlOnlyLogger.isDebugEnabled()) {
                this.sqlOnlyLogger.debug(Slf4jSpyLogDelegator.getDebugInfo() + nl + spy.getConnectionNumber() + ". " + this.processSql(sql));
            } else if (this.sqlOnlyLogger.isInfoEnabled()) {
                this.sqlOnlyLogger.info(this.processSql(sql));
            }
        }
    }

    private String processSql(String sql) {
        if (sql == null) {
            return null;
        }
        if (DriverSpy.TrimSql) {
            sql = sql.trim();
        }
        StringBuilder output = new StringBuilder();
        if (DriverSpy.DumpSqlMaxLineLength <= 0) {
            output.append(sql);
        } else {
            StringTokenizer st = new StringTokenizer(sql);
            int linelength = 0;
            while (st.hasMoreElements()) {
                String token = (String)st.nextElement();
                output.append(token);
                linelength += token.length();
                output.append(" ");
                if (++linelength <= DriverSpy.DumpSqlMaxLineLength) continue;
                output.append("\n");
                linelength = 0;
            }
        }
        if (DriverSpy.DumpSqlAddSemicolon) {
            output.append(";");
        }
        String stringOutput = output.toString();
        if (DriverSpy.TrimExtraBlankLinesInSql) {
            LineNumberReader lineReader = new LineNumberReader(new StringReader(stringOutput));
            output = new StringBuilder();
            int contiguousBlankLines = 0;
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    if (line.trim().length() == 0) {
                        if (++contiguousBlankLines > 1) {
                            continue;
                        }
                    } else {
                        contiguousBlankLines = 0;
                        output.append(line);
                    }
                    output.append("\n");
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            stringOutput = output.toString();
        }
        return stringOutput;
    }

    public void sqlTimingOccured(Spy spy, long execTime, String methodCall, String sql) {
        if (this.sqlTimingLogger.isErrorEnabled() && (!DriverSpy.DumpSqlFilteringOn || this.shouldSqlBeLogged(sql))) {
            if (DriverSpy.SqlTimingErrorThresholdEnabled && execTime >= DriverSpy.SqlTimingErrorThresholdMsec) {
                this.sqlTimingLogger.error(this.buildSqlTimingDump(spy, execTime, methodCall, sql, this.sqlTimingLogger.isDebugEnabled()));
            } else if (this.sqlTimingLogger.isWarnEnabled()) {
                if (DriverSpy.SqlTimingWarnThresholdEnabled && execTime >= DriverSpy.SqlTimingWarnThresholdMsec) {
                    this.sqlTimingLogger.warn(this.buildSqlTimingDump(spy, execTime, methodCall, sql, this.sqlTimingLogger.isDebugEnabled()));
                } else if (this.sqlTimingLogger.isDebugEnabled()) {
                    this.sqlTimingLogger.debug(this.buildSqlTimingDump(spy, execTime, methodCall, sql, true));
                } else if (this.sqlTimingLogger.isInfoEnabled()) {
                    this.sqlTimingLogger.info(this.buildSqlTimingDump(spy, execTime, methodCall, sql, false));
                }
            }
        }
    }

    private String buildSqlTimingDump(Spy spy, long execTime, String methodCall, String sql, boolean debugInfo) {
        StringBuffer out = new StringBuffer();
        if (debugInfo) {
            out.append(Slf4jSpyLogDelegator.getDebugInfo());
            out.append(nl);
            out.append(spy.getConnectionNumber());
            out.append(". ");
        }
        sql = this.processSql(sql);
        out.append(sql);
        out.append(" {executed in ");
        out.append(execTime);
        out.append(" msec}");
        return out.toString();
    }

    private static String getDebugInfo() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace != null) {
            StringBuffer dump = new StringBuffer();
            if (DriverSpy.DumpFullDebugStackTrace) {
                boolean first = true;
                for (int i = 0; i < stackTrace.length; ++i) {
                    String className = stackTrace[i].getClassName();
                    if (className.startsWith("net.sf.log4jdbc")) continue;
                    if (first) {
                        first = false;
                    } else {
                        dump.append("  ");
                    }
                    dump.append("at ");
                    dump.append(stackTrace[i]);
                    dump.append(nl);
                }
            } else {
                int j;
                dump.append(" ");
                int firstLog4jdbcCall = 0;
                int lastApplicationCall = 0;
                for (int i = 0; i < stackTrace.length; ++i) {
                    String className = stackTrace[i].getClassName();
                    if (className.startsWith("net.sf.log4jdbc")) {
                        firstLog4jdbcCall = i;
                        continue;
                    }
                    if (!DriverSpy.TraceFromApplication || !className.startsWith(DriverSpy.DebugStackPrefix)) continue;
                    lastApplicationCall = i;
                    break;
                }
                if ((j = lastApplicationCall) == 0) {
                    j = 1 + firstLog4jdbcCall;
                }
                dump.append(stackTrace[j].getClassName()).append(".").append(stackTrace[j].getMethodName()).append("(").append(stackTrace[j].getFileName()).append(":").append(stackTrace[j].getLineNumber()).append(")");
            }
            return dump.toString();
        }
        return null;
    }

    public void debug(String msg) {
        this.debugLogger.debug(msg);
    }

    public void connectionOpened(Spy spy) {
        if (this.connectionLogger.isDebugEnabled()) {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection opened " + Slf4jSpyLogDelegator.getDebugInfo());
            this.connectionLogger.debug(ConnectionSpy.getOpenConnectionsDump());
        } else {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection opened");
        }
    }

    public void connectionClosed(Spy spy) {
        if (this.connectionLogger.isDebugEnabled()) {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection closed " + Slf4jSpyLogDelegator.getDebugInfo());
            this.connectionLogger.debug(ConnectionSpy.getOpenConnectionsDump());
        } else {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection closed");
        }
    }
}

