/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class AutoClosableLock
implements AutoCloseable {
    private final Lock lock;

    public AutoClosableLock(Lock lock) {
        this.lock = lock;
        this.lock.lock();
    }

    @Override
    public void close() {
        this.lock.unlock();
    }

    public static class AutoClosableTryWriteLock
    implements AutoCloseable {
        private final ReadWriteLock lock;
        private final boolean isLocked;

        public AutoClosableTryWriteLock(ReadWriteLock lock) {
            this.lock = lock;
            this.isLocked = this.lock.writeLock().tryLock();
        }

        public boolean isLocked() {
            return this.isLocked;
        }

        @Override
        public void close() {
            if (this.isLocked) {
                this.lock.writeLock().unlock();
            }
        }
    }

    public static class AutoClosableWriteLock
    implements AutoCloseable {
        private final ReadWriteLock lock;

        public AutoClosableWriteLock(ReadWriteLock lock) {
            this.lock = lock;
            this.lock.writeLock().lock();
        }

        @Override
        public void close() {
            this.lock.writeLock().unlock();
        }
    }

    public static class AutoClosableReadLock
    implements AutoCloseable {
        private final ReadWriteLock lock;

        public AutoClosableReadLock(ReadWriteLock lock) {
            this.lock = lock;
            this.lock.readLock().lock();
        }

        @Override
        public void close() {
            this.lock.readLock().unlock();
        }
    }

    public static class AutoClosableTryLock
    implements AutoCloseable {
        private final Lock lock;
        private final boolean isLocked;

        public AutoClosableTryLock(Lock lock, long timeout, TimeUnit timeUnit) {
            this.lock = lock;
            boolean isLocked = false;
            try {
                isLocked = this.lock.tryLock(timeout, timeUnit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isLocked = isLocked;
        }

        public boolean isLocked() {
            return this.isLocked;
        }

        @Override
        public void close() {
            if (this.isLocked) {
                this.lock.unlock();
            }
        }
    }
}

