/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.UnknownPipelineStateException;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzonePBHelper;
import org.apache.hadoop.security.token.Token;

public final class OmKeyLocationInfo
extends BlockLocationInfo {
    private OmKeyLocationInfo(Builder builder) {
        super((BlockLocationInfo.Builder)builder);
    }

    public OzoneManagerProtocolProtos.KeyLocation getProtobuf(int clientVersion) {
        return this.getProtobuf(false, clientVersion);
    }

    public OzoneManagerProtocolProtos.KeyLocation getProtobuf(boolean ignorePipeline, int clientVersion) {
        OzoneManagerProtocolProtos.KeyLocation.Builder builder = OzoneManagerProtocolProtos.KeyLocation.newBuilder().setBlockID(this.getBlockID().getProtobuf()).setLength(this.getLength()).setOffset(this.getOffset()).setCreateVersion(this.getCreateVersion()).setPartNumber(this.getPartNumber());
        if (!ignorePipeline) {
            try {
                Pipeline pipeline;
                Token token = this.getToken();
                if (token != null) {
                    builder.setToken(OzonePBHelper.protoFromToken(token));
                }
                if ((pipeline = this.getPipeline()) != null) {
                    builder.setPipeline(pipeline.getProtobufMessage(clientVersion));
                }
            }
            catch (UnknownPipelineStateException unknownPipelineStateException) {
                // empty catch block
            }
        }
        return builder.build();
    }

    private static Pipeline getPipeline(OzoneManagerProtocolProtos.KeyLocation keyLocation) {
        try {
            return keyLocation.hasPipeline() ? Pipeline.getFromProtobuf((HddsProtos.Pipeline)keyLocation.getPipeline()) : null;
        }
        catch (UnknownPipelineStateException e) {
            return null;
        }
    }

    public static OmKeyLocationInfo getFromProtobuf(OzoneManagerProtocolProtos.KeyLocation keyLocation) {
        Builder builder = new Builder().setBlockID(BlockID.getFromProtobuf((HddsProtos.BlockID)keyLocation.getBlockID())).setLength(keyLocation.getLength()).setOffset(keyLocation.getOffset()).setPipeline(OmKeyLocationInfo.getPipeline(keyLocation)).setCreateVersion(keyLocation.getCreateVersion()).setPartNumber(keyLocation.getPartNumber());
        if (keyLocation.hasToken()) {
            builder.setToken((Token)OzonePBHelper.tokenFromProto(keyLocation.getToken()));
        }
        return builder.build();
    }

    public static class Builder
    extends BlockLocationInfo.Builder {
        public Builder setBlockID(BlockID blockID) {
            super.setBlockID(blockID);
            return this;
        }

        public Builder setPipeline(Pipeline pipeline) {
            super.setPipeline(pipeline);
            return this;
        }

        public Builder setLength(long length) {
            super.setLength(length);
            return this;
        }

        public Builder setOffset(long offset) {
            super.setOffset(offset);
            return this;
        }

        public Builder setToken(Token<OzoneBlockTokenIdentifier> token) {
            super.setToken(token);
            return this;
        }

        public Builder setPartNumber(int partNumber) {
            super.setPartNumber(partNumber);
            return this;
        }

        public Builder setCreateVersion(long version) {
            super.setCreateVersion(version);
            return this;
        }

        public OmKeyLocationInfo build() {
            return new OmKeyLocationInfo(this);
        }
    }
}

