/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.storm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.storm.client.StormResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceStorm
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceStorm.class);
    public static final String ACCESS_TYPE_GET_TOPOLOGY = "getTopology";
    public static final String ACCESS_TYPE_GET_TOPOLOGY_CONF = "getTopologyConf";
    public static final String ACCESS_TYPE_GET_USER_TOPOLOGY = "getUserTopology";
    public static final String ACCESS_TYPE_GET_TOPOLOGY_INFO = "getTopologyInfo";

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceStorm.getDefaultRangerPolicies()");
        }
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all") || !StringUtils.isNotBlank((String)this.lookUpUser)) continue;
            ArrayList<RangerPolicy.RangerPolicyItemAccess> accessListForLookupUser = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_GET_TOPOLOGY));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_GET_TOPOLOGY_CONF));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_GET_USER_TOPOLOGY));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_GET_TOPOLOGY_INFO));
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(accessListForLookupUser);
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            defaultPolicy.addPolicyItem(policyItemForLookupUser);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceStorm.getDefaultRangerPolicies()");
        }
        return ret;
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceStorm.validateConfig Service: (" + serviceName + " )");
        }
        if (this.configs != null) {
            try {
                ret = StormResourceMgr.validateConfig(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceStorm.validateConfig Error:" + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceStorm.validateConfig Response : (" + ret + " )");
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceStorm.lookupResource Context: (" + context + ")");
        }
        if (context != null) {
            try {
                ret = StormResourceMgr.getStormResources(serviceName, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceStorm.lookupResource Error : " + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceStorm.lookupResource Response: (" + ret + ")");
        }
        return ret;
    }
}

