/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.security.SecurityUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SSLUtil.class);
    public static final String ATLAS_KEYSTORE_FILE_TYPE_DEFAULT = "jks";
    public static final String ATLAS_TRUSTSTORE_FILE_TYPE_DEFAULT = "jks";
    public static final String ATLAS_TLS_CONTEXT_ALGO_TYPE = "TLS";
    public static final String ATLAS_TLS_KEYMANAGER_DEFAULT_ALGO_TYPE = KeyManagerFactory.getDefaultAlgorithm();
    public static final String ATLAS_TLS_TRUSTMANAGER_DEFAULT_ALGO_TYPE = TrustManagerFactory.getDefaultAlgorithm();

    protected Configuration getConfiguration() {
        try {
            return ApplicationProperties.get();
        }
        catch (AtlasException e) {
            throw new RuntimeException("Unable to load configuration: atlas-application.properties");
        }
    }

    private boolean isTLSEnabled() {
        return this.getConfiguration().getBoolean("atlas.enableTLS");
    }

    public void setSSLContext() {
        if (this.isTLSEnabled()) {
            KeyManager[] kmList = this.getKeyManagers();
            TrustManager[] tmList = this.getTrustManagers();
            SSLContext sslContext = null;
            if (tmList != null) {
                try {
                    sslContext = SSLContext.getInstance(ATLAS_TLS_CONTEXT_ALGO_TYPE);
                    sslContext.init(kmList, tmList, new SecureRandom());
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error("SSL algorithm is not available in the environment. Reason: " + e.toString());
                }
                catch (KeyManagementException e) {
                    LOG.error("Unable to initials the SSLContext. Reason: " + e.toString());
                }
            }
            if (sslContext != null) {
                SSLContext.setDefault(sslContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] getKeyManagers() {
        KeyManager[] kmList;
        block19: {
            kmList = null;
            try {
                String keyStoreFile = this.getConfiguration().getString("keystore.file", System.getProperty("keystore.file", "target/atlas.keystore"));
                String keyStoreFilepwd = SecurityUtil.getPassword(this.getConfiguration(), "keystore.password", "cert.stores.credential.provider.path");
                if (!StringUtils.isNotEmpty((String)keyStoreFile) || !StringUtils.isNotEmpty((String)keyStoreFilepwd)) break block19;
                InputStream in = null;
                try {
                    in = this.getFileInputStream(keyStoreFile);
                    if (in != null) {
                        KeyStore keyStore = KeyStore.getInstance(this.getConfiguration().getString("keystore.type", "jks"));
                        keyStore.load(in, keyStoreFilepwd.toCharArray());
                        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(ATLAS_TLS_KEYMANAGER_DEFAULT_ALGO_TYPE);
                        keyManagerFactory.init(keyStore, keyStoreFilepwd.toCharArray());
                        kmList = keyManagerFactory.getKeyManagers();
                    } else {
                        LOG.error("Unable to obtain keystore from file [" + keyStoreFile + "]");
                    }
                }
                catch (KeyStoreException e) {
                    LOG.error("Unable to obtain from KeyStore :" + e.getMessage(), (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error("SSL algorithm is NOT available in the environment", (Throwable)e);
                }
                catch (CertificateException e) {
                    LOG.error("Unable to obtain the requested certification ", (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    LOG.error("Unable to find the necessary TLS Keystore Files", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("Unable to read the necessary TLS Keystore Files", (Throwable)e);
                }
                catch (UnrecoverableKeyException e) {
                    LOG.error("Unable to recover the key from keystore", (Throwable)e);
                }
                finally {
                    this.close(in, keyStoreFile);
                }
            }
            catch (IOException exception) {
                LOG.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return kmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManager[] getTrustManagers() {
        TrustManager[] tmList;
        block17: {
            tmList = null;
            try {
                String truststoreFile = this.getConfiguration().getString("truststore.file", System.getProperty("truststore.file", "target/atlas.keystore"));
                String trustStoreFilepwd = SecurityUtil.getPassword(this.getConfiguration(), "truststore.password", "cert.stores.credential.provider.path");
                if (!StringUtils.isNotEmpty((String)truststoreFile) || !StringUtils.isNotEmpty((String)trustStoreFilepwd)) break block17;
                InputStream in = null;
                try {
                    in = this.getFileInputStream(truststoreFile);
                    if (in != null) {
                        KeyStore trustStore = KeyStore.getInstance(this.getConfiguration().getString("truststore.type", "jks"));
                        trustStore.load(in, trustStoreFilepwd.toCharArray());
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(ATLAS_TLS_TRUSTMANAGER_DEFAULT_ALGO_TYPE);
                        trustManagerFactory.init(trustStore);
                        tmList = trustManagerFactory.getTrustManagers();
                    } else {
                        LOG.error("Unable to obtain truststore from file [" + truststoreFile + "]");
                    }
                }
                catch (KeyStoreException e) {
                    LOG.error("Unable to obtain from KeyStore", (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error("SSL algorithm is NOT available in the environment :" + e.getMessage(), (Throwable)e);
                }
                catch (CertificateException e) {
                    LOG.error("Unable to obtain the requested certification :" + e.getMessage(), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    LOG.error("Unable to find the necessary TLS TrustStore File:" + truststoreFile, (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("Unable to read the necessary TLS TrustStore Files :" + truststoreFile, (Throwable)e);
                }
                finally {
                    this.close(in, truststoreFile);
                }
            }
            catch (IOException exception) {
                LOG.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return tmList;
    }

    private InputStream getFileInputStream(String fileName) throws IOException {
        InputStream in = null;
        if (StringUtils.isNotEmpty((String)fileName)) {
            File f = new File(fileName);
            in = f.exists() ? new FileInputStream(f) : ClassLoader.getSystemResourceAsStream(fileName);
        }
        return in;
    }

    private void close(InputStream str, String filename) {
        if (str != null) {
            try {
                str.close();
            }
            catch (IOException excp) {
                LOG.error("Error while closing file: [" + filename + "]", (Throwable)excp);
            }
        }
    }
}

