/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.logs.model.PatternToken;
import java.util.Map;

@SdkInternalApi
public class PatternTokenMarshaller {
    private static final MarshallingInfo<Integer> DYNAMICTOKENPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamicTokenPosition").build();
    private static final MarshallingInfo<Boolean> ISDYNAMIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isDynamic").build();
    private static final MarshallingInfo<String> TOKENSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenString").build();
    private static final MarshallingInfo<Map> ENUMERATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enumerations").build();
    private static final PatternTokenMarshaller instance = new PatternTokenMarshaller();

    public static PatternTokenMarshaller getInstance() {
        return instance;
    }

    public void marshall(PatternToken patternToken, ProtocolMarshaller protocolMarshaller) {
        if (patternToken == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)patternToken.getDynamicTokenPosition(), DYNAMICTOKENPOSITION_BINDING);
            protocolMarshaller.marshall((Object)patternToken.getIsDynamic(), ISDYNAMIC_BINDING);
            protocolMarshaller.marshall((Object)patternToken.getTokenString(), TOKENSTRING_BINDING);
            protocolMarshaller.marshall(patternToken.getEnumerations(), ENUMERATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

