/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.w3c.domts.DOMTest.load;


/**
 * The method removeNamedItemNS removes a node specified by local name and namespace
 * A removed attribute may be known to have a default value when this map contains the
 * attributes attached to an element, as returned by the attributes attribute of the Node
 * interface. If so, an attribute immediately appears containing the default value as well
 * as the corresponding namespace URI, local name, and prefix when applicable.
 * Retreive a default attribute node.  Remove it from the NodeMap.  Check if a new one immediately
 * appears containing the default value.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-D58B193">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-D58B193</a>
 * @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=259">http://www.w3.org/Bugs/Public/show_bug.cgi?id=259</a>
 */
public class namednodemapremovenameditemns02 {
    @Test
    @Disabled
    public void testRun() throws Throwable {
        String nullNS = null;

        Document doc = load("staffNS", true);
        NodeList elementList = doc.getElementsByTagNameNS("http://www.nist.gov", "employee");
        Node element = elementList.item(1);
        NamedNodeMap attributes = element.getAttributes();
        Attr attribute = (Attr) attributes.removeNamedItemNS(nullNS, "defaultAttr");
        attribute = (Attr) attributes.getNamedItemNS(nullNS, "defaultAttr");
        String attrValue = attribute.getNodeValue();
        assertNotNull(attribute, "namednodemapremovenameditemns02");
        assertEquals("defaultVal", attrValue, "namednodemapremovenameditemns02_attrValue");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/namednodemapremovenameditemns02";
    }

}
