/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typeinference.constraintformulas;

import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.resolution.typeinference.BoundSet;
import com.github.javaparser.symbolsolver.resolution.typeinference.ConstraintFormula;
import com.github.javaparser.symbolsolver.resolution.typeinference.TypeHelper;
import com.github.javaparser.symbolsolver.resolution.typeinference.constraintformulas.TypeSameAsType;
import com.github.javaparser.symbolsolver.resolution.typeinference.constraintformulas.TypeSubtypeOfType;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;

public class TypeCompatibleWithType
extends ConstraintFormula {
    private ResolvedType s;
    private ResolvedType t;
    private TypeSolver typeSolver;

    public TypeCompatibleWithType(TypeSolver typeSolver, ResolvedType s, ResolvedType t) {
        this.typeSolver = typeSolver;
        this.s = s;
        this.t = t;
    }

    @Override
    public ConstraintFormula.ReductionResult reduce(BoundSet currentBoundSet) {
        if (TypeHelper.isProperType(this.s) && TypeHelper.isProperType(this.t)) {
            if (TypeHelper.isCompatibleInALooseInvocationContext(this.s, this.t)) {
                return ConstraintFormula.ReductionResult.trueResult();
            }
            return ConstraintFormula.ReductionResult.falseResult();
        }
        if (this.s.isPrimitive()) {
            ReflectionTypeSolver typeSolver = new ReflectionTypeSolver();
            ReferenceTypeImpl sFirst = new ReferenceTypeImpl(typeSolver.solveType(this.s.asPrimitive().getBoxTypeQName()));
            return ConstraintFormula.ReductionResult.oneConstraint(new TypeCompatibleWithType(typeSolver, (ResolvedType)sFirst, this.t));
        }
        if (this.t.isPrimitive()) {
            ReflectionTypeSolver typeSolver = new ReflectionTypeSolver();
            ReferenceTypeImpl tFirst = new ReferenceTypeImpl(typeSolver.solveType(this.t.asPrimitive().getBoxTypeQName()));
            return ConstraintFormula.ReductionResult.oneConstraint(new TypeSameAsType(this.s, (ResolvedType)tFirst));
        }
        if (this.t.isReferenceType() && this.t.asReferenceType().getTypeDeclaration().isPresent() && !((ResolvedReferenceTypeDeclaration)this.t.asReferenceType().getTypeDeclaration().get()).getTypeParameters().isEmpty()) {
            boolean condition1 = this.t.isAssignableBy(this.s);
            ResolvedType G = this.t.asReferenceType().toRawType();
            boolean condition2 = G.isAssignableBy(this.s);
            if (!condition1 && condition2) {
                return ConstraintFormula.ReductionResult.trueResult();
            }
        }
        if (this.t.isArray()) {
            throw new UnsupportedOperationException();
        }
        return ConstraintFormula.ReductionResult.empty().withConstraint(new TypeSubtypeOfType(this.typeSolver, this.s, this.t));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeCompatibleWithType that = (TypeCompatibleWithType)o;
        if (!this.s.equals(that.s)) {
            return false;
        }
        return this.t.equals(that.t);
    }

    public int hashCode() {
        int result = this.s.hashCode();
        result = 31 * result + this.t.hashCode();
        return result;
    }

    public String toString() {
        return "TypeCompatibleWithType{s=" + this.s + ", t=" + this.t + '}';
    }
}

