/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetSpecialEventPeriodCalendarEntry extends BACnetSpecialEventPeriod
    implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetCalendarEntryEnclosed calendarEntry;

  public BACnetSpecialEventPeriodCalendarEntry(
      BACnetTagHeader peekedTagHeader, BACnetCalendarEntryEnclosed calendarEntry) {
    super(peekedTagHeader);
    this.calendarEntry = calendarEntry;
  }

  public BACnetCalendarEntryEnclosed getCalendarEntry() {
    return calendarEntry;
  }

  @Override
  protected void serializeBACnetSpecialEventPeriodChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetSpecialEventPeriodCalendarEntry");

    // Simple Field (calendarEntry)
    writeSimpleField("calendarEntry", calendarEntry, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetSpecialEventPeriodCalendarEntry");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetSpecialEventPeriodCalendarEntry _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (calendarEntry)
    lengthInBits += calendarEntry.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetSpecialEventPeriodBuilder staticParseBACnetSpecialEventPeriodBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetSpecialEventPeriodCalendarEntry");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetCalendarEntryEnclosed calendarEntry =
        readSimpleField(
            "calendarEntry",
            readComplex(
                () -> BACnetCalendarEntryEnclosed.staticParse(readBuffer, (short) (0)),
                readBuffer));

    readBuffer.closeContext("BACnetSpecialEventPeriodCalendarEntry");
    // Create the instance
    return new BACnetSpecialEventPeriodCalendarEntryBuilderImpl(calendarEntry);
  }

  public static class BACnetSpecialEventPeriodCalendarEntryBuilderImpl
      implements BACnetSpecialEventPeriod.BACnetSpecialEventPeriodBuilder {
    private final BACnetCalendarEntryEnclosed calendarEntry;

    public BACnetSpecialEventPeriodCalendarEntryBuilderImpl(
        BACnetCalendarEntryEnclosed calendarEntry) {
      this.calendarEntry = calendarEntry;
    }

    public BACnetSpecialEventPeriodCalendarEntry build(BACnetTagHeader peekedTagHeader) {
      BACnetSpecialEventPeriodCalendarEntry bACnetSpecialEventPeriodCalendarEntry =
          new BACnetSpecialEventPeriodCalendarEntry(peekedTagHeader, calendarEntry);
      return bACnetSpecialEventPeriodCalendarEntry;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetSpecialEventPeriodCalendarEntry)) {
      return false;
    }
    BACnetSpecialEventPeriodCalendarEntry that = (BACnetSpecialEventPeriodCalendarEntry) o;
    return (getCalendarEntry() == that.getCalendarEntry()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getCalendarEntry());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
