/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// S7PayloadUserDataItemCyclicServicesSubscribeRequest is the corresponding interface of S7PayloadUserDataItemCyclicServicesSubscribeRequest
type S7PayloadUserDataItemCyclicServicesSubscribeRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	S7PayloadUserDataItem
	// GetItemsCount returns ItemsCount (property field)
	GetItemsCount() uint16
	// GetTimeBase returns TimeBase (property field)
	GetTimeBase() TimeBase
	// GetTimeFactor returns TimeFactor (property field)
	GetTimeFactor() uint8
	// GetItem returns Item (property field)
	GetItem() []CycServiceItemType
	// IsS7PayloadUserDataItemCyclicServicesSubscribeRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7PayloadUserDataItemCyclicServicesSubscribeRequest()
	// CreateBuilder creates a S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder
	CreateS7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder() S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder
}

// _S7PayloadUserDataItemCyclicServicesSubscribeRequest is the data-structure of this message
type _S7PayloadUserDataItemCyclicServicesSubscribeRequest struct {
	S7PayloadUserDataItemContract
	ItemsCount uint16
	TimeBase   TimeBase
	TimeFactor uint8
	Item       []CycServiceItemType
}

var _ S7PayloadUserDataItemCyclicServicesSubscribeRequest = (*_S7PayloadUserDataItemCyclicServicesSubscribeRequest)(nil)
var _ S7PayloadUserDataItemRequirements = (*_S7PayloadUserDataItemCyclicServicesSubscribeRequest)(nil)

// NewS7PayloadUserDataItemCyclicServicesSubscribeRequest factory function for _S7PayloadUserDataItemCyclicServicesSubscribeRequest
func NewS7PayloadUserDataItemCyclicServicesSubscribeRequest(returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16, itemsCount uint16, timeBase TimeBase, timeFactor uint8, item []CycServiceItemType) *_S7PayloadUserDataItemCyclicServicesSubscribeRequest {
	_result := &_S7PayloadUserDataItemCyclicServicesSubscribeRequest{
		S7PayloadUserDataItemContract: NewS7PayloadUserDataItem(returnCode, transportSize, dataLength),
		ItemsCount:                    itemsCount,
		TimeBase:                      timeBase,
		TimeFactor:                    timeFactor,
		Item:                          item,
	}
	_result.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder is a builder for S7PayloadUserDataItemCyclicServicesSubscribeRequest
type S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(itemsCount uint16, timeBase TimeBase, timeFactor uint8, item []CycServiceItemType) S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder
	// WithItemsCount adds ItemsCount (property field)
	WithItemsCount(uint16) S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder
	// WithTimeBase adds TimeBase (property field)
	WithTimeBase(TimeBase) S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder
	// WithTimeFactor adds TimeFactor (property field)
	WithTimeFactor(uint8) S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder
	// WithItem adds Item (property field)
	WithItem(...CycServiceItemType) S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() S7PayloadUserDataItemBuilder
	// Build builds the S7PayloadUserDataItemCyclicServicesSubscribeRequest or returns an error if something is wrong
	Build() (S7PayloadUserDataItemCyclicServicesSubscribeRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() S7PayloadUserDataItemCyclicServicesSubscribeRequest
}

// NewS7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder() creates a S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder
func NewS7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder() S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder {
	return &_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder{_S7PayloadUserDataItemCyclicServicesSubscribeRequest: new(_S7PayloadUserDataItemCyclicServicesSubscribeRequest)}
}

type _S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder struct {
	*_S7PayloadUserDataItemCyclicServicesSubscribeRequest

	parentBuilder *_S7PayloadUserDataItemBuilder

	collectedErr []error
}

var _ (S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) = (*_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder)(nil)

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) setParent(contract S7PayloadUserDataItemContract) {
	b.S7PayloadUserDataItemContract = contract
	contract.(*_S7PayloadUserDataItem)._SubType = b._S7PayloadUserDataItemCyclicServicesSubscribeRequest
}

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) WithMandatoryFields(itemsCount uint16, timeBase TimeBase, timeFactor uint8, item []CycServiceItemType) S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder {
	return b.WithItemsCount(itemsCount).WithTimeBase(timeBase).WithTimeFactor(timeFactor).WithItem(item...)
}

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) WithItemsCount(itemsCount uint16) S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder {
	b.ItemsCount = itemsCount
	return b
}

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) WithTimeBase(timeBase TimeBase) S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder {
	b.TimeBase = timeBase
	return b
}

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) WithTimeFactor(timeFactor uint8) S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder {
	b.TimeFactor = timeFactor
	return b
}

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) WithItem(item ...CycServiceItemType) S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder {
	b.Item = item
	return b
}

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) Build() (S7PayloadUserDataItemCyclicServicesSubscribeRequest, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._S7PayloadUserDataItemCyclicServicesSubscribeRequest.deepCopy(), nil
}

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) MustBuild() S7PayloadUserDataItemCyclicServicesSubscribeRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) Done() S7PayloadUserDataItemBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewS7PayloadUserDataItemBuilder().(*_S7PayloadUserDataItemBuilder)
	}
	return b.parentBuilder
}

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) buildForS7PayloadUserDataItem() (S7PayloadUserDataItem, error) {
	return b.Build()
}

func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder) DeepCopy() any {
	_copy := b.CreateS7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder().(*_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateS7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder creates a S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder
func (b *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) CreateS7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder() S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder {
	if b == nil {
		return NewS7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder()
	}
	return &_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder{_S7PayloadUserDataItemCyclicServicesSubscribeRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetCpuFunctionGroup() uint8 {
	return 0x02
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetCpuFunctionType() uint8 {
	return 0x04
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetCpuSubfunction() uint8 {
	return 0x01
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetParent() S7PayloadUserDataItemContract {
	return m.S7PayloadUserDataItemContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetItemsCount() uint16 {
	return m.ItemsCount
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetTimeBase() TimeBase {
	return m.TimeBase
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetTimeFactor() uint8 {
	return m.TimeFactor
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetItem() []CycServiceItemType {
	return m.Item
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastS7PayloadUserDataItemCyclicServicesSubscribeRequest(structType any) S7PayloadUserDataItemCyclicServicesSubscribeRequest {
	if casted, ok := structType.(S7PayloadUserDataItemCyclicServicesSubscribeRequest); ok {
		return casted
	}
	if casted, ok := structType.(*S7PayloadUserDataItemCyclicServicesSubscribeRequest); ok {
		return *casted
	}
	return nil
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetTypeName() string {
	return "S7PayloadUserDataItemCyclicServicesSubscribeRequest"
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).getLengthInBits(ctx))

	// Simple field (itemsCount)
	lengthInBits += 16

	// Simple field (timeBase)
	lengthInBits += 8

	// Simple field (timeFactor)
	lengthInBits += 8

	// Array field
	if len(m.Item) > 0 {
		for _curItem, element := range m.Item {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Item), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_S7PayloadUserDataItem, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (__s7PayloadUserDataItemCyclicServicesSubscribeRequest S7PayloadUserDataItemCyclicServicesSubscribeRequest, err error) {
	m.S7PayloadUserDataItemContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("S7PayloadUserDataItemCyclicServicesSubscribeRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7PayloadUserDataItemCyclicServicesSubscribeRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	itemsCount, err := ReadSimpleField(ctx, "itemsCount", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'itemsCount' field"))
	}
	m.ItemsCount = itemsCount

	timeBase, err := ReadEnumField[TimeBase](ctx, "timeBase", "TimeBase", ReadEnum(TimeBaseByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeBase' field"))
	}
	m.TimeBase = timeBase

	timeFactor, err := ReadSimpleField(ctx, "timeFactor", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeFactor' field"))
	}
	m.TimeFactor = timeFactor

	item, err := ReadCountArrayField[CycServiceItemType](ctx, "item", ReadComplex[CycServiceItemType](CycServiceItemTypeParseWithBuffer, readBuffer), uint64(itemsCount))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'item' field"))
	}
	m.Item = item

	if closeErr := readBuffer.CloseContext("S7PayloadUserDataItemCyclicServicesSubscribeRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7PayloadUserDataItemCyclicServicesSubscribeRequest")
	}

	return m, nil
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7PayloadUserDataItemCyclicServicesSubscribeRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for S7PayloadUserDataItemCyclicServicesSubscribeRequest")
		}

		if err := WriteSimpleField[uint16](ctx, "itemsCount", m.GetItemsCount(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'itemsCount' field")
		}

		if err := WriteSimpleEnumField[TimeBase](ctx, "timeBase", "TimeBase", m.GetTimeBase(), WriteEnum[TimeBase, uint8](TimeBase.GetValue, TimeBase.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
			return errors.Wrap(err, "Error serializing 'timeBase' field")
		}

		if err := WriteSimpleField[uint8](ctx, "timeFactor", m.GetTimeFactor(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'timeFactor' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "item", m.GetItem(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'item' field")
		}

		if popErr := writeBuffer.PopContext("S7PayloadUserDataItemCyclicServicesSubscribeRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for S7PayloadUserDataItemCyclicServicesSubscribeRequest")
		}
		return nil
	}
	return m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) IsS7PayloadUserDataItemCyclicServicesSubscribeRequest() {
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) deepCopy() *_S7PayloadUserDataItemCyclicServicesSubscribeRequest {
	if m == nil {
		return nil
	}
	_S7PayloadUserDataItemCyclicServicesSubscribeRequestCopy := &_S7PayloadUserDataItemCyclicServicesSubscribeRequest{
		m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).deepCopy(),
		m.ItemsCount,
		m.TimeBase,
		m.TimeFactor,
		utils.DeepCopySlice[CycServiceItemType, CycServiceItemType](m.Item),
	}
	_S7PayloadUserDataItemCyclicServicesSubscribeRequestCopy.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = m
	return _S7PayloadUserDataItemCyclicServicesSubscribeRequestCopy
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
