/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEscalatorFaultTagged is the corresponding interface of BACnetEscalatorFaultTagged
type BACnetEscalatorFaultTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetEscalatorFault
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetEscalatorFaultTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEscalatorFaultTagged()
	// CreateBuilder creates a BACnetEscalatorFaultTaggedBuilder
	CreateBACnetEscalatorFaultTaggedBuilder() BACnetEscalatorFaultTaggedBuilder
}

// _BACnetEscalatorFaultTagged is the data-structure of this message
type _BACnetEscalatorFaultTagged struct {
	Header           BACnetTagHeader
	Value            BACnetEscalatorFault
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetEscalatorFaultTagged = (*_BACnetEscalatorFaultTagged)(nil)

// NewBACnetEscalatorFaultTagged factory function for _BACnetEscalatorFaultTagged
func NewBACnetEscalatorFaultTagged(header BACnetTagHeader, value BACnetEscalatorFault, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetEscalatorFaultTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetEscalatorFaultTagged must not be nil")
	}
	return &_BACnetEscalatorFaultTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEscalatorFaultTaggedBuilder is a builder for BACnetEscalatorFaultTagged
type BACnetEscalatorFaultTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetEscalatorFault, proprietaryValue uint32) BACnetEscalatorFaultTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetEscalatorFaultTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEscalatorFaultTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetEscalatorFault) BACnetEscalatorFaultTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetEscalatorFaultTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetEscalatorFaultTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetEscalatorFaultTaggedBuilder
	// Build builds the BACnetEscalatorFaultTagged or returns an error if something is wrong
	Build() (BACnetEscalatorFaultTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEscalatorFaultTagged
}

// NewBACnetEscalatorFaultTaggedBuilder() creates a BACnetEscalatorFaultTaggedBuilder
func NewBACnetEscalatorFaultTaggedBuilder() BACnetEscalatorFaultTaggedBuilder {
	return &_BACnetEscalatorFaultTaggedBuilder{_BACnetEscalatorFaultTagged: new(_BACnetEscalatorFaultTagged)}
}

type _BACnetEscalatorFaultTaggedBuilder struct {
	*_BACnetEscalatorFaultTagged

	collectedErr []error
}

var _ (BACnetEscalatorFaultTaggedBuilder) = (*_BACnetEscalatorFaultTaggedBuilder)(nil)

func (b *_BACnetEscalatorFaultTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetEscalatorFault, proprietaryValue uint32) BACnetEscalatorFaultTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetEscalatorFaultTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetEscalatorFaultTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetEscalatorFaultTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEscalatorFaultTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetEscalatorFaultTaggedBuilder) WithValue(value BACnetEscalatorFault) BACnetEscalatorFaultTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetEscalatorFaultTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetEscalatorFaultTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetEscalatorFaultTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetEscalatorFaultTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetEscalatorFaultTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetEscalatorFaultTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetEscalatorFaultTaggedBuilder) Build() (BACnetEscalatorFaultTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetEscalatorFaultTagged.deepCopy(), nil
}

func (b *_BACnetEscalatorFaultTaggedBuilder) MustBuild() BACnetEscalatorFaultTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEscalatorFaultTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEscalatorFaultTaggedBuilder().(*_BACnetEscalatorFaultTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetEscalatorFaultTaggedBuilder creates a BACnetEscalatorFaultTaggedBuilder
func (b *_BACnetEscalatorFaultTagged) CreateBACnetEscalatorFaultTaggedBuilder() BACnetEscalatorFaultTaggedBuilder {
	if b == nil {
		return NewBACnetEscalatorFaultTaggedBuilder()
	}
	return &_BACnetEscalatorFaultTaggedBuilder{_BACnetEscalatorFaultTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEscalatorFaultTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetEscalatorFaultTagged) GetValue() BACnetEscalatorFault {
	return m.Value
}

func (m *_BACnetEscalatorFaultTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetEscalatorFaultTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetEscalatorFault_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEscalatorFaultTagged(structType any) BACnetEscalatorFaultTagged {
	if casted, ok := structType.(BACnetEscalatorFaultTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEscalatorFaultTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEscalatorFaultTagged) GetTypeName() string {
	return "BACnetEscalatorFaultTagged"
}

func (m *_BACnetEscalatorFaultTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetEscalatorFaultTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetEscalatorFaultTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetEscalatorFaultTagged, error) {
	return BACnetEscalatorFaultTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetEscalatorFaultTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEscalatorFaultTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEscalatorFaultTagged, error) {
		return BACnetEscalatorFaultTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetEscalatorFaultTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetEscalatorFaultTagged, error) {
	v, err := (&_BACnetEscalatorFaultTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetEscalatorFaultTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetEscalatorFaultTagged BACnetEscalatorFaultTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEscalatorFaultTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEscalatorFaultTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetEscalatorFault](ctx, "value", readBuffer, EnsureType[BACnetEscalatorFault](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetEscalatorFault_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetEscalatorFault_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetEscalatorFaultTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEscalatorFaultTagged")
	}

	return m, nil
}

func (m *_BACnetEscalatorFaultTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEscalatorFaultTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetEscalatorFaultTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetEscalatorFaultTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetEscalatorFault](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetEscalatorFaultTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetEscalatorFaultTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetEscalatorFaultTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetEscalatorFaultTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetEscalatorFaultTagged) IsBACnetEscalatorFaultTagged() {}

func (m *_BACnetEscalatorFaultTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEscalatorFaultTagged) deepCopy() *_BACnetEscalatorFaultTagged {
	if m == nil {
		return nil
	}
	_BACnetEscalatorFaultTaggedCopy := &_BACnetEscalatorFaultTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetEscalatorFaultTaggedCopy
}

func (m *_BACnetEscalatorFaultTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
