/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDoorAlarmState is the corresponding interface of BACnetConstructedDataDoorAlarmState
type BACnetConstructedDataDoorAlarmState interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDoorAlarmState returns DoorAlarmState (property field)
	GetDoorAlarmState() BACnetDoorAlarmStateTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDoorAlarmStateTagged
	// IsBACnetConstructedDataDoorAlarmState is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDoorAlarmState()
	// CreateBuilder creates a BACnetConstructedDataDoorAlarmStateBuilder
	CreateBACnetConstructedDataDoorAlarmStateBuilder() BACnetConstructedDataDoorAlarmStateBuilder
}

// _BACnetConstructedDataDoorAlarmState is the data-structure of this message
type _BACnetConstructedDataDoorAlarmState struct {
	BACnetConstructedDataContract
	DoorAlarmState BACnetDoorAlarmStateTagged
}

var _ BACnetConstructedDataDoorAlarmState = (*_BACnetConstructedDataDoorAlarmState)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDoorAlarmState)(nil)

// NewBACnetConstructedDataDoorAlarmState factory function for _BACnetConstructedDataDoorAlarmState
func NewBACnetConstructedDataDoorAlarmState(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, doorAlarmState BACnetDoorAlarmStateTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDoorAlarmState {
	if doorAlarmState == nil {
		panic("doorAlarmState of type BACnetDoorAlarmStateTagged for BACnetConstructedDataDoorAlarmState must not be nil")
	}
	_result := &_BACnetConstructedDataDoorAlarmState{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		DoorAlarmState:                doorAlarmState,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDoorAlarmStateBuilder is a builder for BACnetConstructedDataDoorAlarmState
type BACnetConstructedDataDoorAlarmStateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(doorAlarmState BACnetDoorAlarmStateTagged) BACnetConstructedDataDoorAlarmStateBuilder
	// WithDoorAlarmState adds DoorAlarmState (property field)
	WithDoorAlarmState(BACnetDoorAlarmStateTagged) BACnetConstructedDataDoorAlarmStateBuilder
	// WithDoorAlarmStateBuilder adds DoorAlarmState (property field) which is build by the builder
	WithDoorAlarmStateBuilder(func(BACnetDoorAlarmStateTaggedBuilder) BACnetDoorAlarmStateTaggedBuilder) BACnetConstructedDataDoorAlarmStateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDoorAlarmState or returns an error if something is wrong
	Build() (BACnetConstructedDataDoorAlarmState, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDoorAlarmState
}

// NewBACnetConstructedDataDoorAlarmStateBuilder() creates a BACnetConstructedDataDoorAlarmStateBuilder
func NewBACnetConstructedDataDoorAlarmStateBuilder() BACnetConstructedDataDoorAlarmStateBuilder {
	return &_BACnetConstructedDataDoorAlarmStateBuilder{_BACnetConstructedDataDoorAlarmState: new(_BACnetConstructedDataDoorAlarmState)}
}

type _BACnetConstructedDataDoorAlarmStateBuilder struct {
	*_BACnetConstructedDataDoorAlarmState

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataDoorAlarmStateBuilder) = (*_BACnetConstructedDataDoorAlarmStateBuilder)(nil)

func (b *_BACnetConstructedDataDoorAlarmStateBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDoorAlarmState
}

func (b *_BACnetConstructedDataDoorAlarmStateBuilder) WithMandatoryFields(doorAlarmState BACnetDoorAlarmStateTagged) BACnetConstructedDataDoorAlarmStateBuilder {
	return b.WithDoorAlarmState(doorAlarmState)
}

func (b *_BACnetConstructedDataDoorAlarmStateBuilder) WithDoorAlarmState(doorAlarmState BACnetDoorAlarmStateTagged) BACnetConstructedDataDoorAlarmStateBuilder {
	b.DoorAlarmState = doorAlarmState
	return b
}

func (b *_BACnetConstructedDataDoorAlarmStateBuilder) WithDoorAlarmStateBuilder(builderSupplier func(BACnetDoorAlarmStateTaggedBuilder) BACnetDoorAlarmStateTaggedBuilder) BACnetConstructedDataDoorAlarmStateBuilder {
	builder := builderSupplier(b.DoorAlarmState.CreateBACnetDoorAlarmStateTaggedBuilder())
	var err error
	b.DoorAlarmState, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDoorAlarmStateTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataDoorAlarmStateBuilder) Build() (BACnetConstructedDataDoorAlarmState, error) {
	if b.DoorAlarmState == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'doorAlarmState' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataDoorAlarmState.deepCopy(), nil
}

func (b *_BACnetConstructedDataDoorAlarmStateBuilder) MustBuild() BACnetConstructedDataDoorAlarmState {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDoorAlarmStateBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDoorAlarmStateBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDoorAlarmStateBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDoorAlarmStateBuilder().(*_BACnetConstructedDataDoorAlarmStateBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataDoorAlarmStateBuilder creates a BACnetConstructedDataDoorAlarmStateBuilder
func (b *_BACnetConstructedDataDoorAlarmState) CreateBACnetConstructedDataDoorAlarmStateBuilder() BACnetConstructedDataDoorAlarmStateBuilder {
	if b == nil {
		return NewBACnetConstructedDataDoorAlarmStateBuilder()
	}
	return &_BACnetConstructedDataDoorAlarmStateBuilder{_BACnetConstructedDataDoorAlarmState: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDoorAlarmState) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDoorAlarmState) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DOOR_ALARM_STATE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDoorAlarmState) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDoorAlarmState) GetDoorAlarmState() BACnetDoorAlarmStateTagged {
	return m.DoorAlarmState
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataDoorAlarmState) GetActualValue() BACnetDoorAlarmStateTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDoorAlarmStateTagged(m.GetDoorAlarmState())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDoorAlarmState(structType any) BACnetConstructedDataDoorAlarmState {
	if casted, ok := structType.(BACnetConstructedDataDoorAlarmState); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDoorAlarmState); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDoorAlarmState) GetTypeName() string {
	return "BACnetConstructedDataDoorAlarmState"
}

func (m *_BACnetConstructedDataDoorAlarmState) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (doorAlarmState)
	lengthInBits += m.DoorAlarmState.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataDoorAlarmState) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDoorAlarmState) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDoorAlarmState BACnetConstructedDataDoorAlarmState, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDoorAlarmState"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDoorAlarmState")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	doorAlarmState, err := ReadSimpleField[BACnetDoorAlarmStateTagged](ctx, "doorAlarmState", ReadComplex[BACnetDoorAlarmStateTagged](BACnetDoorAlarmStateTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'doorAlarmState' field"))
	}
	m.DoorAlarmState = doorAlarmState

	actualValue, err := ReadVirtualField[BACnetDoorAlarmStateTagged](ctx, "actualValue", (*BACnetDoorAlarmStateTagged)(nil), doorAlarmState)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDoorAlarmState"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDoorAlarmState")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDoorAlarmState) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDoorAlarmState) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDoorAlarmState"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDoorAlarmState")
		}

		if err := WriteSimpleField[BACnetDoorAlarmStateTagged](ctx, "doorAlarmState", m.GetDoorAlarmState(), WriteComplex[BACnetDoorAlarmStateTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'doorAlarmState' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDoorAlarmState"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDoorAlarmState")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDoorAlarmState) IsBACnetConstructedDataDoorAlarmState() {}

func (m *_BACnetConstructedDataDoorAlarmState) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDoorAlarmState) deepCopy() *_BACnetConstructedDataDoorAlarmState {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDoorAlarmStateCopy := &_BACnetConstructedDataDoorAlarmState{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDoorAlarmStateTagged](m.DoorAlarmState),
	}
	_BACnetConstructedDataDoorAlarmStateCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDoorAlarmStateCopy
}

func (m *_BACnetConstructedDataDoorAlarmState) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
