/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.cditest.owb;

import java.util.Enumeration;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

/**
 * A simple mock HttpSession
 */
public class MockHttpSession implements HttpSession
{

    @Override
    public long getCreationTime()
    {
        return 0;
    }

    @Override
    public String getId()
    {
        return "sessId1";
    }

    @Override
    public long getLastAccessedTime()
    {
        return 0;
    }

    @Override
    public ServletContext getServletContext()
    {
        return null;
    }

    @Override
    public void setMaxInactiveInterval(int interval)
    {
    }

    @Override
    public int getMaxInactiveInterval()
    {
        return 0;
    }

    @Override
    public HttpSessionContext getSessionContext()
    {
        return null;
    }

    @Override
    public Object getAttribute(String name)
    {
        return null;
    }

    @Override
    public Object getValue(String name)
    {
        return null;
    }

    @Override
    public Enumeration getAttributeNames()
    {
        return null;
    }

    @Override
    public String[] getValueNames()
    {
        return new String[0];
    }

    @Override
    public void setAttribute(String name, Object value)
    {
    }

    @Override
    public void putValue(String name, Object value)
    {
    }

    @Override
    public void removeAttribute(String name)
    {
    }

    @Override
    public void removeValue(String name)
    {
    }

    @Override
    public void invalidate()
    {
    }

    @Override
    public boolean isNew()
    {
        return false;
    }

}
