/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import org.apache.openjpa.persistence.query.AliasContext;
import org.apache.openjpa.persistence.query.ExpressionImpl;
import org.apache.openjpa.persistence.query.JPQLHelper;
import org.apache.openjpa.persistence.query.Visitable;

public class ArrayExpression
extends ExpressionImpl {
    private static final long serialVersionUID = 1L;
    private final Object[] _values;

    public ArrayExpression(Object[] values) {
        this._values = values;
    }

    @Override
    public String asExpression(AliasContext ctx) {
        StringBuilder tmp = new StringBuilder("(");
        for (int i = 0; i < this._values.length; ++i) {
            Object v = this._values[i];
            tmp.append(v instanceof Visitable ? ((Visitable)v).asExpression(ctx) : JPQLHelper.toJPQL(ctx, v)).append(i == this._values.length - 1 ? "" : ", ");
        }
        tmp.append(")");
        return tmp.toString();
    }

    @Override
    public String asProjection(AliasContext ctx) {
        return this.asExpression(ctx);
    }
}

