/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlEntityKey;
import org.apache.olingo.client.core.edm.xml.ClientCsdlNavigationProperty;
import org.apache.olingo.client.core.edm.xml.ClientCsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;

@JsonDeserialize(using=EntityTypeDeserializer.class)
class ClientCsdlEntityType
extends CsdlEntityType
implements Serializable {
    private static final long serialVersionUID = -3986417775876689669L;

    ClientCsdlEntityType() {
    }

    static class EntityTypeDeserializer
    extends AbstractClientCsdlEdmDeserializer<CsdlEntityType> {
        EntityTypeDeserializer() {
        }

        @Override
        protected CsdlEntityType doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlEntityType entityType = new ClientCsdlEntityType();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        entityType.setName(jp.nextTextValue());
                    } else if ("Abstract".equals(jp.getCurrentName())) {
                        entityType.setAbstract(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("BaseType".equals(jp.getCurrentName())) {
                        entityType.setBaseType(jp.nextTextValue());
                    } else if ("OpenType".equals(jp.getCurrentName())) {
                        entityType.setOpenType(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("HasStream".equals(jp.getCurrentName())) {
                        entityType.setHasStream(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("Key".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        ClientCsdlEntityKey keyImpl = (ClientCsdlEntityKey)jp.readValueAs(ClientCsdlEntityKey.class);
                        entityType.setKey(keyImpl.getPropertyRefs());
                    } else if ("Property".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        entityType.getProperties().add(jp.readValueAs(ClientCsdlProperty.class));
                    } else if ("NavigationProperty".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        entityType.getNavigationProperties().add(jp.readValueAs(ClientCsdlNavigationProperty.class));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        entityType.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return entityType;
        }
    }
}

