/****************************************************************************
 * arch/x86_64/src/intel64/intel64_hpet_alarm.c
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#include <nuttx/timers/arch_alarm.h>

#include "intel64_oneshot.h"

/****************************************************************************
 * Public Functions
 ****************************************************************************/

#ifdef CONFIG_ARCH_INTEL64_HPET_ALARM
void up_timer_initialize(void)
{
  struct oneshot_lowerhalf_s *lower =
    oneshot_initialize(CONFIG_ARCH_INTEL64_HPET_ALARM_CHAN, 10);
  up_alarm_set_lowerhalf(lower);
}
#endif
