/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command;

import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Result;
import org.apache.nifi.toolkit.cli.api.Session;
import org.apache.nifi.toolkit.cli.impl.command.AbstractCommand;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.session.SessionVariable;

public abstract class AbstractPropertyCommand<R extends Result>
extends AbstractCommand<R> {
    public AbstractPropertyCommand(String name, Class<R> resultClass) {
        super(name, resultClass);
    }

    @Override
    public final R execute(CommandLine commandLine) throws CommandException {
        try {
            Properties properties = new Properties();
            if (commandLine.hasOption(CommandOption.PROPERTIES.getLongName())) {
                String propertiesFile = commandLine.getOptionValue(CommandOption.PROPERTIES.getLongName());
                if (!StringUtils.isBlank((CharSequence)propertiesFile)) {
                    try (FileInputStream in = new FileInputStream(propertiesFile);){
                        properties.load(in);
                    }
                }
            } else {
                Session session;
                String sessionPropsFiles;
                SessionVariable sessionVariable = this.getPropertiesSessionVariable();
                if (sessionVariable != null && !StringUtils.isBlank((CharSequence)(sessionPropsFiles = (session = this.getContext().getSession()).get(sessionVariable.getVariableName())))) {
                    try (FileInputStream in = new FileInputStream(sessionPropsFiles);){
                        properties.load(in);
                    }
                }
            }
            for (Option option : commandLine.getOptions()) {
                String optValue = option.getValue() == null ? "" : option.getValue();
                properties.setProperty(option.getLongOpt(), optValue);
            }
            return this.doExecute(properties);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command '" + this.getName() + "' : " + e.getMessage(), e);
        }
    }

    protected abstract SessionVariable getPropertiesSessionVariable();

    public abstract R doExecute(Properties var1) throws CommandException;
}

