/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ConnectionClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;

public class PGConnect
extends AbstractNiFiCommand<StringResult> {
    public PGConnect() {
        super("pg-connect", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Connects the output port of the source process group to the input port of a destination process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.SOURCE_PG.createOption());
        this.addOption(CommandOption.SOURCE_OUTPUT_PORT.createOption());
        this.addOption(CommandOption.DESTINATION_PG.createOption());
        this.addOption(CommandOption.DESTINATION_INPUT_PORT.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String sourcePgId = this.getRequiredArg(properties, CommandOption.SOURCE_PG);
        String sourceOutputPort = this.getRequiredArg(properties, CommandOption.SOURCE_OUTPUT_PORT);
        String destinationPgId = this.getRequiredArg(properties, CommandOption.DESTINATION_PG);
        String destinationInputPort = this.getRequiredArg(properties, CommandOption.DESTINATION_INPUT_PORT);
        Object source = null;
        PortEntity destination = null;
        FlowClient pgClient = client.getFlowClient();
        ProcessGroupFlowEntity sourcePgEntity = pgClient.getProcessGroup(sourcePgId);
        ProcessGroupFlowEntity destinationPgEntity = pgClient.getProcessGroup(destinationPgId);
        String parentPgId = sourcePgEntity.getProcessGroupFlow().getParentGroupId();
        if (!parentPgId.equals(destinationPgEntity.getProcessGroupFlow().getParentGroupId())) {
            throw new IOException("The source process group and the destination process group are not at the same level");
        }
        Set outputPorts = sourcePgEntity.getProcessGroupFlow().getFlow().getOutputPorts();
        for (Object outputPort : outputPorts) {
            if (!outputPort.getComponent().getName().equals(sourceOutputPort)) continue;
            source = outputPort;
            break;
        }
        if (source == null) {
            throw new IOException("Unable to find an output port with the name '" + sourceOutputPort + "' in the source process group");
        }
        Set inputPorts = destinationPgEntity.getProcessGroupFlow().getFlow().getInputPorts();
        for (PortEntity inputPort : inputPorts) {
            if (!inputPort.getComponent().getName().equals(destinationInputPort)) continue;
            destination = inputPort;
            break;
        }
        if (destination == null) {
            throw new IOException("Unable to find an input port with the name '" + destinationInputPort + "' in the destination process group");
        }
        ConnectionEntity connectionEntity = new ConnectionEntity();
        connectionEntity.setDestinationGroupId(destinationPgId);
        connectionEntity.setDestinationId(destination.getId());
        connectionEntity.setDestinationType(destination.getPortType());
        connectionEntity.setSourceGroupId(sourcePgId);
        connectionEntity.setSourceId(source.getId());
        connectionEntity.setSourceType(source.getPortType());
        RevisionDTO revisionDto = new RevisionDTO();
        revisionDto.setClientId(this.getClass().getName());
        revisionDto.setVersion(Long.valueOf(0L));
        connectionEntity.setRevision(revisionDto);
        ConnectionDTO connectionDto = new ConnectionDTO();
        connectionDto.setDestination(this.createConnectableDTO(destination));
        connectionDto.setSource(this.createConnectableDTO((PortEntity)source));
        connectionDto.setParentGroupId(parentPgId);
        connectionEntity.setComponent(connectionDto);
        ConnectionClient connectionClient = client.getConnectionClient();
        ConnectionEntity createdEntity = connectionClient.createConnection(parentPgId, connectionEntity);
        return new StringResult(createdEntity.getId(), this.getContext().isInteractive());
    }

    private ConnectableDTO createConnectableDTO(PortEntity port) {
        ConnectableDTO dto = new ConnectableDTO();
        dto.setGroupId(port.getComponent().getParentGroupId());
        dto.setId(port.getId());
        dto.setName(port.getComponent().getName());
        dto.setRunning(Boolean.valueOf("RUNNING".equalsIgnoreCase(port.getComponent().getState())));
        dto.setType(port.getPortType());
        return dto;
    }
}

