/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package examples.imageviewer;

/** Instances of this class create internal frames to display given images.
 */
public class ImageFrame extends javax.swing.JInternalFrame {

    /** ImageFrame constructor.
     * It creates new internal frame containing the given image and displays it.
     */
    public ImageFrame(String imageName ) {
        initComponents();
        setTitle(imageName);
        imageLabel.setIcon(new javax.swing.ImageIcon(imageName) );
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jScrollPane1 = new javax.swing.JScrollPane();
        imageLabel = new javax.swing.JLabel();

        setClosable(true);
        setIconifiable(true);
        setResizable(true);
        getAccessibleContext().setAccessibleName("Image Internal Frame");
        getAccessibleContext().setAccessibleDescription("Image internal frame.");
        jScrollPane1.setViewportView(imageLabel);
        imageLabel.getAccessibleContext().setAccessibleName("Image Label");
        imageLabel.getAccessibleContext().setAccessibleDescription("Image label.");

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel imageLabel;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

}
