/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;

public final class FallbackDefaultJavaPlatform
extends JavaPlatform {
    private static final Logger LOG = Logger.getLogger(FallbackDefaultJavaPlatform.class.getName());
    private static final Map<String, String> JAVADOC_URLS;
    private static FallbackDefaultJavaPlatform instance;
    private volatile List<URL> javadoc;
    private volatile ClassPath src;

    private FallbackDefaultJavaPlatform() {
        this.setSystemProperties(NbCollections.checkedMapByFilter(System.getProperties(), String.class, String.class, false));
    }

    @Override
    public String getDisplayName() {
        return System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.version");
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.singletonMap("platform.ant.name", "default_platform");
    }

    private static ClassPath sysProp2CP(String propname) {
        String sbcp = System.getProperty(propname);
        if (sbcp == null) {
            return null;
        }
        ArrayList<URL> roots = new ArrayList<URL>();
        StringTokenizer tok = new StringTokenizer(sbcp, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            URL u;
            File f = new File(tok.nextToken());
            if (!f.exists()) continue;
            try {
                File normf = FileUtil.normalizeFile(f);
                u = Utilities.toURI(normf).toURL();
            }
            catch (MalformedURLException x) {
                throw new AssertionError((Object)x);
            }
            if (FileUtil.isArchiveFile(u)) {
                u = FileUtil.getArchiveRoot(u);
            }
            roots.add(u);
        }
        return ClassPathSupport.createClassPath(roots.toArray(new URL[roots.size()]));
    }

    private static ClassPath sampleClass2CP(Class prototype) {
        URL[] uRLArray;
        CodeSource cs = prototype.getProtectionDomain().getCodeSource();
        if (cs != null) {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = cs.getLocation();
        } else {
            uRLArray = new URL[]{};
        }
        return ClassPathSupport.createClassPath(uRLArray);
    }

    @Override
    public ClassPath getBootstrapLibraries() {
        ClassPath cp = FallbackDefaultJavaPlatform.sysProp2CP("sun.boot.class.path");
        return cp != null ? cp : FallbackDefaultJavaPlatform.sampleClass2CP(Object.class);
    }

    @Override
    public ClassPath getStandardLibraries() {
        ClassPath cp = FallbackDefaultJavaPlatform.sysProp2CP("java.class.path");
        return cp != null ? cp : FallbackDefaultJavaPlatform.sampleClass2CP(Dependency.class);
    }

    @Override
    public String getVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    public Specification getSpecification() {
        return new Specification("j2se", Dependency.JAVA_SPEC);
    }

    @Override
    public Collection<FileObject> getInstallFolders() {
        return Collections.singleton(FileUtil.toFileObject(FileUtil.normalizeFile(new File(System.getProperty("java.home")))));
    }

    @Override
    public FileObject findTool(String toolName) {
        return null;
    }

    @Override
    public ClassPath getSourceFolders() {
        ClassPath res = this.src;
        if (res == null) {
            res = this.src = ClassPathSupport.createClassPath(FallbackDefaultJavaPlatform.getSources(this.getInstallFolders()));
        }
        return res;
    }

    @Override
    public List<URL> getJavadocFolders() {
        List<URL> res = this.javadoc;
        if (res == null) {
            SpecificationVersion version = this.getSpecification().getVersion();
            URL root = FallbackDefaultJavaPlatform.toURL(JAVADOC_URLS.get(version.toString()));
            this.javadoc = root == null ? Collections.emptyList() : Collections.singletonList(root);
            res = this.javadoc;
        }
        return res;
    }

    @NonNull
    private static FileObject[] getSources(@NonNull Collection<? extends FileObject> installFolders) {
        FileObject reloc;
        if (installFolders.isEmpty()) {
            return new FileObject[0];
        }
        FileObject installFolder = installFolders.iterator().next();
        if (installFolder == null || !installFolder.isValid()) {
            return new FileObject[0];
        }
        FileObject src = installFolder.getFileObject("src.zip");
        if (src == null) {
            src = installFolder.getFileObject("src.jar");
        }
        if (src == null || !src.canRead()) {
            return new FileObject[0];
        }
        FileObject root = FileUtil.getArchiveRoot(src);
        if (root == null) {
            return new FileObject[0];
        }
        if (Utilities.getOperatingSystem() == 4096 && (reloc = root.getFileObject("src")) != null) {
            root = reloc;
        }
        return new FileObject[]{root};
    }

    @CheckForNull
    private static URL toURL(@NullAllowed String root) {
        if (root == null) {
            return null;
        }
        try {
            return new URL(root);
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "Invalid Javadoc root: {0}", root);
            return null;
        }
    }

    public static synchronized FallbackDefaultJavaPlatform getInstance() {
        if (instance == null) {
            instance = new FallbackDefaultJavaPlatform();
        }
        return instance;
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1.5", "https://docs.oracle.com/javase/1.5.0/docs/api/");
        m.put("1.6", "https://docs.oracle.com/javase/6/docs/api/");
        m.put("1.7", "https://docs.oracle.com/javase/7/docs/api/");
        m.put("1.8", "https://docs.oracle.com/javase/8/docs/api/");
        JAVADOC_URLS = Collections.unmodifiableMap(m);
    }
}

