/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.DummyFormRequestInfo;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;

public class DummyFormUtils {
    private static final Log log = LogFactory.getLog(DummyFormUtils.class);
    public static final String DUMMY_FORM_NAME = "linkDummyForm";
    private static final String DUMMY_FORM_ID = "linkDummyForm";
    public static final String DUMMY_FORM_INFO = DummyFormUtils.class.getName() + ".DUMMY_FORM_INFO";

    public static String getDummyFormName() {
        return "linkDummyForm";
    }

    public static void setWriteDummyForm(FacesContext facesContext, boolean writeDummyForm) {
        if (!writeDummyForm) {
            return;
        }
        if (!DummyFormUtils.isWriteDummyForm(facesContext)) {
            DummyFormRequestInfo dummyFormInfo = new DummyFormRequestInfo();
            facesContext.getExternalContext().getRequestMap().put(DUMMY_FORM_INFO, dummyFormInfo);
        }
    }

    public static boolean isWriteDummyForm(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap().containsKey(DUMMY_FORM_INFO);
    }

    public static void addDummyFormParameter(FacesContext facesContext, String paramName) {
        if (DummyFormUtils.isWriteDummyForm(facesContext)) {
            DummyFormRequestInfo dummyFormInfo = (DummyFormRequestInfo)facesContext.getExternalContext().getRequestMap().get(DUMMY_FORM_INFO);
            dummyFormInfo.addDummyFormParameter(paramName);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Dummy Form parameter was not added because dummy form is not written");
        }
    }

    public static Set getDummyFormParameters(FacesContext facesContext) {
        if (DummyFormUtils.isWriteDummyForm(facesContext)) {
            DummyFormRequestInfo dummyFormInfo = (DummyFormRequestInfo)facesContext.getExternalContext().getRequestMap().get(DUMMY_FORM_INFO);
            return dummyFormInfo.getDummyFormParams();
        }
        return new HashSet();
    }

    public static void writeDummyForm(ResponseWriter writer, Set dummyFormParams) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String actionURL = viewHandler.getActionURL(facesContext, viewId);
        writer.startElement("form", null);
        writer.writeAttribute("id", (Object)"linkDummyForm", null);
        writer.writeAttribute("name", (Object)"linkDummyForm", null);
        writer.writeAttribute("style", (Object)"display:inline", null);
        writer.writeAttribute("method", (Object)"post", null);
        writer.writeURIAttribute("action", (Object)facesContext.getExternalContext().encodeActionURL(actionURL), null);
        writer.flush();
        StateManager stateManager = facesContext.getApplication().getStateManager();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        StateManager.SerializedView serializedView = stateManager.saveSerializedView(facesContext);
        if (stateManager.isSavingStateInClient(facesContext)) {
            stateManager.writeState(facesContext, serializedView);
        }
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isAutoScroll()) {
            HtmlRendererUtils.renderAutoScrollHiddenInput(facesContext, writer);
        }
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        if (dummyFormParams != null) {
            HtmlRendererUtils.renderHiddenCommandFormParams(writer, dummyFormParams);
            HtmlRendererUtils.renderClearHiddenCommandFormParamsFunction(writer, "linkDummyForm", dummyFormParams, null);
        }
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("form");
    }

    public static FormInfo findNestingForm(UIComponent uiComponent, FacesContext facesContext) {
        FormInfo formInfo = RendererUtils.findNestingForm(uiComponent, facesContext);
        if (formInfo != null) {
            return formInfo;
        }
        DummyFormUtils.setWriteDummyForm(facesContext, true);
        return new FormInfo(null, "linkDummyForm");
    }
}

