/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_orchestra.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static List getExceptions(Throwable cause) {
        Throwable nextCause;
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(10);
        exceptions.add(cause);
        do {
            try {
                Method rootCause = cause.getClass().getMethod("getRootCause", new Class[0]);
                nextCause = (Throwable)rootCause.invoke((Object)cause, new Object[0]);
            }
            catch (Exception e) {
                nextCause = cause.getCause();
            }
            if (cause == nextCause) break;
            if (nextCause == null) continue;
            exceptions.add(nextCause);
        } while ((cause = nextCause) != null);
        return exceptions;
    }

    public static String getExceptionMessage(List throwables) {
        if (throwables == null) {
            return null;
        }
        for (int i = throwables.size() - 1; i > 0; --i) {
            Throwable t = (Throwable)throwables.get(i);
            if (t.getMessage() == null) continue;
            return t.getMessage();
        }
        return null;
    }
}

