/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.FacesWrapper;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.myfaces.spi.StateCacheProvider;
import org.apache.myfaces.spi.impl.DefaultStateCacheProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class StateCacheProviderFactory
implements FacesWrapper<StateCacheProviderFactory> {
    private static final String FACTORY_KEY = StateCacheProviderFactory.class.getName();

    public static StateCacheProviderFactory getStateCacheProviderFactory(ExternalContext ctx) {
        StateCacheProviderFactory instance = (StateCacheProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        StateCacheProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                ExternalContext ectx = ctx;
                lpf = (StateCacheProviderFactory)AccessController.doPrivileged(() -> SpiUtils.build(ectx, StateCacheProviderFactory.class, DefaultStateCacheProviderFactory.class));
            } else {
                lpf = (StateCacheProviderFactory)SpiUtils.build(ctx, StateCacheProviderFactory.class, DefaultStateCacheProviderFactory.class);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException(pae);
        }
        if (lpf != null) {
            StateCacheProviderFactory.setStateCacheProviderFactory(ctx, lpf);
        }
        return lpf;
    }

    public static void setStateCacheProviderFactory(ExternalContext ctx, StateCacheProviderFactory instance) {
        ctx.getApplicationMap().put(FACTORY_KEY, instance);
    }

    public StateCacheProvider getStateCacheProvider(ExternalContext ctx) {
        return this.createStateCacheProvider(ctx);
    }

    public abstract StateCacheProvider createStateCacheProvider(ExternalContext var1);

    @Override
    public StateCacheProviderFactory getWrapped() {
        return null;
    }
}

