/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.shared.component.EscapeCapable;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.SelectItemInfo;
import org.apache.myfaces.shared.util.SelectItemsIterator;

public class SelectItemsUtils {
    private static final char TABULATOR = '\t';

    public static List<SelectItemInfo> getSelectItemInfoList(UISelectMany uiSelectMany, FacesContext facesContext) {
        ArrayList<SelectItemInfo> list = new ArrayList<SelectItemInfo>();
        SelectItemsIterator iter = new SelectItemsIterator(uiSelectMany, facesContext);
        while (iter.hasNext()) {
            list.add(new SelectItemInfo(iter.next(), iter.getCurrentComponent(), iter.getCurrentValue()));
        }
        return list;
    }

    public static List<SelectItemInfo> getSelectItemInfoList(UISelectOne uiSelectOne, FacesContext facesContext) {
        ArrayList<SelectItemInfo> list = new ArrayList<SelectItemInfo>();
        SelectItemsIterator iter = new SelectItemsIterator(uiSelectOne, facesContext);
        while (iter.hasNext()) {
            list.add(new SelectItemInfo(iter.next(), iter.getCurrentComponent(), iter.getCurrentValue()));
        }
        return list;
    }

    public static void renderSelectOptions(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List<SelectItemInfo> selectItemList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean hideNoSelectionOption = HtmlRendererUtils.isHideNoSelectionOption(component);
        boolean componentDisabled = SelectItemsUtils.isTrue(component.getAttributes().get("disabled"));
        for (int i = 0; i < selectItemList.size(); ++i) {
            boolean escape;
            boolean disabled;
            SelectItemInfo selectItemInfo = selectItemList.get(i);
            SelectItem selectItem = selectItemInfo.getItem();
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("optgroup", selectItemInfo.getComponent());
                writer.writeAttribute("label", selectItem.getLabel(), null);
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                ArrayList<SelectItemInfo> selectItemsGroupList = new ArrayList<SelectItemInfo>(selectItems.length);
                for (SelectItem item : selectItems) {
                    selectItemsGroupList.add(new SelectItemInfo(item, null));
                }
                SelectItemsUtils.renderSelectOptions(context, component, converter, lookupSet, selectItemsGroupList);
                writer.endElement("optgroup");
                continue;
            }
            String itemStrValue = RendererUtils.getConvertedStringValue(context, component, converter, selectItem);
            boolean selected = lookupSet.contains(itemStrValue);
            if (hideNoSelectionOption && selectItem.isNoSelectionOption() && !lookupSet.isEmpty() && (lookupSet.size() != 1 || !lookupSet.contains("")) && !selected) continue;
            writer.write(9);
            boolean wroteRequestMapVarValue = false;
            Object oldRequestMapVarValue = null;
            String var = null;
            if (selectItemInfo != null && selectItemInfo.getComponent() instanceof UISelectItems && (var = (String)selectItemInfo.getComponent().getAttributes().get("var")) != null && !"".equals(var)) {
                oldRequestMapVarValue = context.getExternalContext().getRequestMap().put(var, selectItemInfo.getValue());
                wroteRequestMapVarValue = true;
            }
            writer.startElement("option", selectItemInfo.getComponent());
            if (itemStrValue != null) {
                writer.writeAttribute("value", itemStrValue, null);
            } else {
                writer.writeAttribute("value", "", null);
            }
            if (selected) {
                writer.writeAttribute("selected", "selected", null);
            }
            if (disabled = selectItem.isDisabled()) {
                writer.writeAttribute("disabled", "disabled", null);
            }
            String labelClass = null;
            labelClass = componentDisabled || disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
            if (labelClass != null) {
                writer.writeAttribute("class", labelClass, "labelClass");
            }
            if (component instanceof EscapeCapable) {
                escape = ((EscapeCapable)((Object)component)).isEscape();
                if (escape && selectItem.isEscape()) {
                    writer.writeText(selectItem.getLabel(), null);
                } else {
                    writer.write(selectItem.getLabel());
                }
            } else {
                escape = RendererUtils.getBooleanAttribute(component, "escape", false);
                if (escape || selectItem.isEscape()) {
                    writer.writeText(selectItem.getLabel(), null);
                } else {
                    writer.write(selectItem.getLabel());
                }
            }
            writer.endElement("option");
            if (!wroteRequestMapVarValue) continue;
            if (oldRequestMapVarValue != null) {
                context.getExternalContext().getRequestMap().put(var, oldRequestMapVarValue);
                continue;
            }
            context.getExternalContext().getRequestMap().remove(var);
        }
    }

    private static boolean isTrue(Object obj) {
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }
}

